package serveur;

import java.io.Serializable;
import java.util.Random;

import serveur.exceptions.ServeurException;

abstract class Jeton implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public final ServeurInfos initiateur;
	private int nbTour;
	
	private int id;
	
	public Jeton(ServeurInfos initiateur){
		this.initiateur = initiateur;
		nbTour = -1;
		id = new Random().nextInt(1000000000);
	}
	
	public abstract ActionTraitementJeton traiterJeton(Serveur serveur) throws ServeurException;
	
	public void incrNbTour(){
		nbTour++;
	}
	
	public int getNbTour(){
		return nbTour;
	}
	
	public int getId(){
		return id;
	}
	
	public String toString(){
		return "("+this.getClass().getSimpleName() + "=" + id + "<-" +initiateur+")";
	}
}
