import java.net.* ;

// importation des classes utiles � Jasper
import se.sics.jasper.*;

// pour les lectures au clavier
import java.io.*;

// pour utiliser les HashMap 
import java.util.*;

public class Moteur {

    public static String solutionUnResultatMax( SICStus sp,
						String saisie,
						String J,
						String TC,
						String L1,
						String C1,
						    String L2,
						String C2,
						String O){
	
	String resultat = new String("");
	
	
	// HashMap utilis pour stocker les solutions
	HashMap results = new HashMap();
	
	try {
	    // Creation d'une requete (Query) Sicstus
	    //   - en fonction de la saisie de l'utilisateur 
	    //   - instanciera results avec les rsultats de la requte
	    Query qu = sp.openQuery(saisie,results);
	    
	    // parcours des solutions
	    boolean moreSols = qu.nextSolution();
	    
	    // on ne boucle que si la liste des instanciations de variables est non vide 
	    boolean continuer = !(results.isEmpty());
	    
	    resultat += results.get(J).toString();
	    resultat += ";"+results.get(TC).toString();
	    resultat += ";"+results.get(L1).toString();
	    resultat += ";"+results.get(C1).toString();
	    resultat += ";"+results.get(L2).toString();
	    resultat += ";"+results.get(C2).toString();
	    resultat += ";"+results.get(O).toString();
	    
	    qu.close();
	}
	catch (SPException e) {
	    System.err.println("Exception prolog\n" + e);
	}
	
	// autres exceptions leves par l'utilisation du Query.nextSolution()
	catch (Exception e) {
	    System.err.println("Other exception : " + e);
	}
	
	
	return resultat;
    }
    
    public static void EnvoiToC(Socket s, String chaine){
	
	
	try {
	    
/*
  OutputStream os = s.getOutputStream();
  InputStream is = s.getInputStream();
*/	    
	    PrintWriter sortie = new PrintWriter(s.getOutputStream(), true);
	    
	    sortie.println(chaine);
	    
	    BufferedReader entree = new BufferedReader(new InputStreamReader(s.getInputStream()));
	    
	    
	    boolean continu = true;
	    
	    while (continu){
		
		String ligne = entree.readLine();
		if (ligne==null) continu=false;
		else System.out.println(ligne);
		
	    }
	    
	} 
	catch ( UnknownHostException e ) { 
	    
	    System.out.println("Unknown host" + e);
	}
	catch ( IOException e) { 
	    
	    System.out.println("IO exception" + e);
	}
	
	
    }

    
    
    public static void main(String [] args) {
	
	int port = 8007;
	int i = 0;
	
	String resultat = new String("");
	SICStus sp = null;
	
	try {
	    
	    // Creation d'un object SICStus
	    sp = new SICStus();
	    
	    // Chargement d'un fichier prolog .pl
	    sp.load("./siam.pl");
	    
	}
	// exception dclanche par SICStus lors de la cration de l'objet sp
	catch (SPException e) {
	    System.err.println("Exception SICStus Prolog : " + e);
	    e.printStackTrace();
	    System.exit(-2);
	}
	
	boolean arret = false;
	boolean jouer = false;

	ServerSocket srv;
	String chaine = new String("");
	String resultat2 = new String("");
	
	try {
	    
	    System.out.println("Moteur IA -->: Lancement du moteur sur le port : " + port + ".");
	    srv = new ServerSocket(port) ;
	    
	    while (!arret) {
		
		/* faire la demande initialisation jeu ?*/
		jouer = true;
		
		while (jouer){
		    
		    /* Reception d'une requete */
		    System.out.println("Moteur IA --> Attente d'une connexion du joueur.");
		    Socket s = srv.accept() ;
		    
		    OutputStream os =  s.getOutputStream();
		    InputStream is = s.getInputStream();
		    
		    byte[] TableauDeByte = new byte[1000];
		    
		    System.out.println("Moteur IA --> Attente de la requete du joueur.");
		    int recu = is.read(TableauDeByte);
		    		    
		    for (i=0; i < TableauDeByte.length; i++){
			
			String caractere= new Character((char)TableauDeByte[i]).toString();
			chaine += caractere;
			
		    }
		    
		    System.out.println("Joueur --> Requete: " + chaine);	    

		    System.out.println("Moteur IA --> Envoi de la requete a Prolog.");
		    resultat2 = solutionUnResultatMax( sp, chaine, "J", "TC", "L1", "C1", "L2", "C2", "O");
		    System.out.println("          --> Resultat prolog: " + resultat2);

		    System.out.println("Moteur IA --> Envoi du coup au joueur.");
		    EnvoiToC(s, resultat2);
		    
		    is.close();
		    os.close();
		    s.close();	
		    
		    chaine = "";
		}
	    }
	    
	}
	catch (IOException e){
	    System.out.println("erreur socket: "+e);
	}
    }
    
}
