package server;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * Gestionnaire du topic
 * @author cmoutenet
 *
 */
public class TopicCertificatServeur {
	private final Session topicSession;
	MessageProducer producer;
	ServeurPret serveurPret;
	Connection cnx;

	public TopicCertificatServeur(String topicName, String topicFactoryName,
			Queue queue, QueueConnectionFactory qcf) throws NamingException,
			JMSException {
		serveurPret = new ServeurPret(queue, qcf);

		InitialContext ictx = new InitialContext();
		Topic topic = (Topic) ictx.lookup(topicName);
		ConnectionFactory cf = (ConnectionFactory) ictx
				.lookup(topicFactoryName);
		ictx.close();

		cnx = cf.createConnection();
		// Mode non transaction, avec acquitement des messages
		topicSession = cnx.createSession(false, Session.CLIENT_ACKNOWLEDGE);
		producer = topicSession.createProducer(topic);

		cnx.start();
	}

	public void sendPret() throws JMSException {
		ObjectMessage msg = topicSession.createObjectMessage();
		msg.setObject(serveurPret);
		producer.send(msg);

	}

	public void close() {
		try {
			cnx.close();
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

}
