package relais;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import server.ServeurPret;


public class TopicRelaisServeur implements MessageListener {
	private final Session topicSession;
	private final RelaisServer serveur;

	public TopicRelaisServeur(RelaisServer serveur, String topicName,
			String topicFactoryName) throws NamingException, JMSException {
		this.serveur = serveur;
		InitialContext ictx = new InitialContext();
		Topic topic = (Topic) ictx.lookup(topicName);
		ConnectionFactory cf = (ConnectionFactory) ictx
				.lookup(topicFactoryName);
		ictx.close();

		Connection cnx = cf.createConnection();
		// Mode non transaction, avec acquitement des messages
		topicSession = cnx.createSession(false, Session.CLIENT_ACKNOWLEDGE);
		MessageConsumer subs = topicSession.createConsumer(topic);

		subs.setMessageListener(this);

		cnx.start();
	}

	public void onMessage(Message msg) {
		ObjectMessage objMsg = (ObjectMessage) msg;
		try {
			Object obj = objMsg.getObject();
			if (obj instanceof ServeurPret) {
				ServeurPret serveurPret = (ServeurPret) obj;
				serveur.setServeurPret(serveurPret.getQueue(), serveurPret
						.getQueueConnexionFactory());
				msg.acknowledge();
			}
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

	public void close() {
		try {
			topicSession.close();
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

}
