#!/bin/bash

TBB_HOME="/home/riku/Informatique/Cours/Master 2/Projet/tbb21_014oss"
TBB_LIBS="/home/riku/Informatique/Cours/Master 2/Projet/tbb21_014oss/build/linux_ia32_gcc_cc4.3.2_libc2.8.90_kernel2.6.27_release"

export JAVA_HOME=/home/riku/Informatique/Outils/j2ee/jdk1.6.0
export PATH=$JAVA_HOME/bin:/usr/local/bin:/usr/bin:/bin:/usr/bin/X11:/usr/games
export LD_LIBRARY_PATH=$TBB_LIBS

if test $# -ne 5
then
    echo "USAGE : $0 min max incr nb_threads nb_time"
    echo "        min : min size of the matrice"
    echo "        max : max size of the matrice"
    echo "        incr : increment of the size of the matrice"
    echo "        nb_threads : number of threads"
    echo "        nb_time : number of time"
    exit -1
fi

test_name="matrice"
TestName="Matrice"

c_impl="c_nothread c_pthreads c_openmp"
java_impl="JavaNoThread JavaThread"
csharp_impl="CSharpNoThread CSharpThread"
cpp_impl="cpp_tbb"

nbthread=$4;
echo $JAVA_HOME
echo -e "m_size;nb_threads;used_library;exec_time" > result.csv

for ((m_size=$1;m_size<=$2;m_size+=$3))
do

    echo "Doing for matrice($m_size) with $nbthread thread(s)"

    # Implementation en C
    for impl in $c_impl
    do

        # Option du compilateur
        case $impl in
        "c_pthreads") comp_opt=" -pthread";;
        "c_openmp") comp_opt=" -fopenmp";;
        *) comp_opt="";;
        esac

        echo "    with $impl -opt:$comp_opt at `date +%H:%M:%S`"

        # Compilation et lancement
        (
            cd $impl
            gcc -g -Wall -std=c99 -ansi -pedantic -O3 $comp_opt -o "${test_name}_${impl}" "${test_name}_${impl}.c"
            # Nombre de fois
            for ((time=1;time<=$5;time+=1))
            do
                ./${test_name}_${impl} $m_size $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr "${test_name}_${impl}" *~
        )
    done

    # Implementation en JAVA
    for impl in $java_impl
    do
        echo "    with $impl at `date +%H:%M:%S`"

        # Compilation et lancement
        (
            cd $impl
            javac "${TestName}${impl}.java"
            # Nombre de fois
            for ((time=1;time<=$5;time+=1))
            do
                java "${TestName}${impl}" $m_size $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr *.class *~
        )
    done

    # Implementation en CSHARP
    for impl in $csharp_impl
    do
        echo "    with $impl at `date +%H:%M:%S`"
        
        # Compilation et lancement
        (
            cd $impl
            mcs "${TestName}${impl}.cs"
            # Nombre de fois
            for ((time=1;time<=$5;time+=1))
            do
                mono "./${TestName}${impl}.exe" $m_size $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr "${TestName}${impl}.exe" *~
        )
    done

    # Implementation en C++
    for impl in $cpp_impl
    do

        # Option du compilateur
        case $impl in
        "cpp_tbb") comp_opt=" -ltbb";;
        *) comp_opt="";;
        esac

        echo "    with $impl -opt:$comp_opt at `date +%H:%M:%S`"

        # Compilation et lancement
        (
            cd $impl
            g++ -Wall -ansi -pedantic -O3 -I"$TBB_HOME/include" -L"$TBB_LIBS" $comp_opt -o "${test_name}_${impl}" "${test_name}_${impl}.cc"
            # Nombre de fois
            for ((time=1;time<=$5;time+=1))
            do
                ./${test_name}_${impl} $m_size $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr "${test_name}_${impl}" *~
        )
    done

done

rm -fr *~
