#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <pthread.h>

#include <sys/time.h>

void *task (void *p_data)
{
  int i=0;
  i++;
  return NULL;
}

int main(int argc, char **argv) {
  
  struct timeval tv_start, tv_finish;
  double realtime;
  double average;

  int nb_threads;

  int i;

  pthread_t th;
  
  if(argc < 1){
    printf("USAGE : %s nb_threads\n", argv[0]);
    printf(         "n_threads : an integer\n");
    return -1;
  }
  
  /* Depart du chrono */
  gettimeofday(&tv_start, 0);
  
  nb_threads=atoi(argv[1]);
  for(i=0;i<=nb_threads;i++){
    pthread_create (&th, NULL, task, (void*)NULL);
    pthread_join (th, NULL);
  }
  
  /* Fin du chrono */
  gettimeofday(&tv_finish, 0);
  
  /* Affichage du resultat */
  realtime = (double)(tv_finish.tv_sec-tv_start.tv_sec) +
    ((double)(tv_finish.tv_usec-tv_start.tv_usec))*1e-6;
  if(nb_threads > 0){
    average = realtime / (nb_threads + 0.0);
  }else{
    average = realtime;
  }
    
  printf("%d;c_pthreads;%f;%f\n", nb_threads, realtime, average);
  
  return 0;
}
