/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import jsr166y.forkjoin.AbstractParallelAnyArray;
import jsr166y.forkjoin.CommonOps;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelArrayWithMapping;

public abstract class ParallelArrayWithFilter<T>
extends ParallelArrayWithMapping<T, T> {
    ParallelArrayWithFilter(ForkJoinExecutor ex, int origin, int fence, T[] array) {
        super(ex, origin, fence, array);
    }

    public ParallelArrayWithFilter<T> replaceWithMapping(Ops.Op<? super T, ? extends T> op) {
        this.ex.invoke(new PAS.FJOTransform(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelArrayWithFilter<T> replaceWithMappedIndex(Ops.IntToObject<? extends T> op) {
        this.ex.invoke(new PAS.FJOIndexMap(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelArrayWithFilter<T> replaceWithMappedIndex(Ops.IntAndObjectToObject<? super T, ? extends T> op) {
        this.ex.invoke(new PAS.FJOBinaryIndexMap(this, this.origin, this.fence, null, op));
        return this;
    }

    public ParallelArrayWithFilter<T> replaceWithGeneratedValue(Ops.Generator<? extends T> generator) {
        this.ex.invoke(new PAS.FJOGenerate(this, this.origin, this.fence, null, generator));
        return this;
    }

    public ParallelArrayWithFilter<T> replaceWithValue(T value) {
        this.ex.invoke(new PAS.FJOFill(this, this.origin, this.fence, null, value));
        return this;
    }

    public <V, W> ParallelArrayWithFilter<T> replaceWithMapping(Ops.BinaryOp<? super T, ? super V, ? extends T> combiner, ParallelArrayWithMapping<W, V> other) {
        this.ex.invoke(new PAS.FJOPACombineInPlace(this, this.origin, this.fence, null, other, other.origin - this.origin, combiner));
        return this;
    }

    public ParallelArrayWithFilter<T> replaceWithMapping(Ops.BinaryOp<T, T, T> combiner, T[] other) {
        this.ex.invoke(new PAS.FJOCombineInPlace(this, this.origin, this.fence, null, other, -this.origin, combiner));
        return this;
    }

    public ParallelArray<T> allUniqueElements() {
        PAS.UniquifierTable tab = new PAS.UniquifierTable(this.fence - this.origin, this, false);
        PAS.FJOUniquifier f = new PAS.FJOUniquifier(this, this.origin, this.fence, null, tab);
        this.ex.invoke(f);
        Object[] res = tab.uniqueObjects(f.count);
        return new ParallelArray<Object>(this.ex, res);
    }

    public ParallelArray<T> allNonidenticalElements() {
        PAS.UniquifierTable tab = new PAS.UniquifierTable(this.fence - this.origin, this, true);
        PAS.FJOUniquifier f = new PAS.FJOUniquifier(this, this.origin, this.fence, null, tab);
        this.ex.invoke(f);
        Object[] res = tab.uniqueObjects(f.count);
        return new ParallelArray<Object>(this.ex, res);
    }

    public abstract ParallelArrayWithFilter<T> withFilter(Ops.Predicate<? super T> var1);

    public <V, W> ParallelArrayWithFilter<T> withFilter(Ops.BinaryPredicate<? super T, ? super V> selector, ParallelArrayWithMapping<W, V> other) {
        return this.withIndexedFilter(AbstractParallelAnyArray.indexedSelector(selector, other, this.origin));
    }

    public abstract ParallelArrayWithFilter<T> withIndexedFilter(Ops.IntAndObjectPredicate<? super T> var1);

    public <U, V> boolean hasAllEqualElements(ParallelArrayWithMapping<U, V> other) {
        return this.withFilter(CommonOps.inequalityPredicate(), other).anyIndex() < 0;
    }

    public <U, V> boolean hasAllIdenticalElements(ParallelArrayWithMapping<U, V> other) {
        return this.withFilter(CommonOps.nonidentityPredicate(), other).anyIndex() < 0;
    }

    @Override
    final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
        Object[] a = this.array;
        for (int i = lo; i < hi; ++i) {
            dest[offset++] = a[i];
        }
    }

    @Override
    final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
        Object[] a = this.array;
        for (int i = loIdx; i < hiIdx; ++i) {
            dest[offset++] = a[indices[i]];
        }
    }

    @Override
    final Object oget(int i) {
        return this.array[i];
    }
}

