package minijaja.ihm.vue;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import minijaja.ihm.controleur.*;

/**
 * Compilateur.ihm.EditeurMiniJaja.java
 * @author Ludovic
 * cree le 16 nov. 07
 */
public class EditeurMiniJaja extends Composite {

	private StyledText monStyledText = null;
	JavaLineStyler miniJajaColoration = new JavaLineStyler();

	/**
	 * Constructeur de la classe ihm.EditeurMiniJaja.java
	 * @param parent <code><b><i> Composite </i></b></code>: composite de niveau superieur
	 * @param style <code><b><i> int </i></b></code> : style de ce composite
	 */
	public EditeurMiniJaja(Composite parent, int style) {
		super(parent, style);
		initialize();
	}
	
	/**
	 * EditeurMiniJaja.initialize
	 * Cette methode initialise le conteneur composite de la vue.
	 * @return void
	 */
	private void initialize() {
		monStyledText = initializeMonStyledText();
		setSize(new Point(300, 200));
		setLayout(new GridLayout());
	}
	
	
	/* --- Dclarations : --- */
	
	private StyledText initializeMonStyledText(){
		
		StyledText text = new StyledText(this, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL
		        | SWT.H_SCROLL);
		    
			GridData spec = new GridData();
		    spec.horizontalAlignment = GridData.FILL;
		    spec.grabExcessHorizontalSpace = true;
		    spec.verticalAlignment = GridData.FILL;
		    spec.grabExcessVerticalSpace = true;
		    text.setLayoutData(spec);
		    text.addLineStyleListener(miniJajaColoration);
		    text.setEditable(false);
		    Color bg = Display.getDefault().getSystemColor(SWT.COLOR_GRAY);
		    text.setBackground(bg);
		    
		    return text;
	}

	/**
	 * Revoie la valeur du membre miniJajaColoration.
	 */
	public JavaLineStyler getMiniJajaColoration() {
		return miniJajaColoration;
	}

	/**
	 * Affecte une nouvelle valeur au membre miniJajaColoration.
	 */
	public void setMiniJajaColoration(JavaLineStyler miniJajaColoration) {
		this.miniJajaColoration = miniJajaColoration;
	}

	public StyledText getMonStyledText(){
		return monStyledText;
	}
	
}
