package memoire;

import java.util.EmptyStackException;
import java.util.Stack;


/**
 * Classe qui cree une pile pour la memoire d'execution du compilateur
 * 
 * @author Richard Ludovic
 * @see java.util.Stack
 */
public class Pile extends Stack<Qua>{

	private static final long serialVersionUID = 1L;
	
	
	/**
	 * Constructeur de la classe memoire.Pile2.java
	 */
	public Pile() {
		super();
	}
	
	public int getTaille() {
		return this.size();
	  }
	

	/**
	 * Test si une pile est vide (meme si elle contient des
	 * Elements inutilises).
	 */
	public boolean estVide(){
		return this.isEmpty();
	}
	  
	 /**
	  * Test si une pile est vierge (ne contient aucun element).
	  */
	 public boolean estVierge(){
		 return (this.getTaille() == 0);
	 }
	  
	 /**
	  * Ajoute un element au sommet de la pile.
	  * @param q Quadruplet a empiler
	  * @return Quadruplet empile
	  */
	 public Qua empiler(Qua q){
	   return this.push(q);
	 }
	  
	  /**
	   * Supprime un element au sommet de la pile.
	   * @param q Quadruplet a depiler
	   * @return Quadruplet depile
	   */
	  public Qua depiler(){
	    
	    if (this.estVide()){// pile vide.
	    	throw new EmptyStackException();
	    }
	    return this.pop(); 
	  } 
	  
	  /**
	   * Echange 2 valeur au sommet de la pile.
	   * Alias : Swap
	   */
	  public void echanger(){
		  Qua q1, q2;
		  
		  q1 = this.depiler();
		  q2 = this.depiler();
		  
		  this.empiler(q1);
		  this.empiler(q2);
	  }
	  
	  
	  /**
	   * Recherche si un quadruplet est dans la pile.
	   * @param q quadruplet recherche
	   * @return Vrai si trouve, faux sinon
	   */
	  public boolean contient(Qua q){
		  return this.contains(q);
	  }
	  
	  /**
	   * Recheche la premiere position d'un quadruplet dans la pile
	   *
	   * @param q quadruplet recherche
	   * @return un entier positif ou null qui represente la position de "q" dans la pile, ou -1
	   */
	  public int rechercher(Qua q){
		 return this.search(q);
	  }
	
	  /**
	   * Recheche la premiere position d'un quadruplet dans la pile
	   *
	   * @param i identifiant du quadruplet recherche
	   * @return un entier positif ou null qui represente la position de "q" dans la pile, ou -1 
	   */
	  public int rechercher(String i){
		 
		int adr = this.getTaille()-1;
		
		boolean trouve = false;
		
		while(!trouve && adr >= 0){
			if(this.elementAt(adr).getId().equals(i)){
				trouve = true;
			}else{
				adr--;
			}
		}
		
		if(trouve){
			return adr;
		}else{
			return -1; // erreur
		}
		  
	  }
	  
	  /**
	   * Affiche la pile dans une chaine de caracteres
	   * @return une chaine de caracteres
	   */
	  public String toString(){
		  String res = "";
		  int pileTaille = this.size();
		  if(pileTaille==0){
			  res = "[]";
		  }else{
			  for(int i=pileTaille-1;i>=0;i--){
				  if(i!=pileTaille-1){
					  res += ".";
				  }
				  res += this.elementAt(i);
			  }
		  }
		  return res;
	  }
	
	  public static void main(String[] args) {
		  
		  Pile pile = new Pile(); 
		  Qua q;
		  String k;
			
			System.out.println("Dbut du test de pile");
			
			k="a";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="b";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="x";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="y";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="Class";
			q = new Qua(k,1,"meth","~");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="IDENT";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="popoldesiles";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="d_g_f_a";
			q = new Qua(k,1,"v","e");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			k="y"; 
			q = new Qua(k,0,"v","B");
			pile.empiler(q);
			System.out.println(pile.contient(q));
			System.out.println(pile.rechercher(q));
			
			System.out.println("\n");
			System.out.println("-------------------------------------------------------------");
			System.out.println(pile.toString());
			System.out.println("-------------------------------------------------------------");
			System.out.println("\n");
			
			pile.echanger();
			
			System.out.println("\n");
			System.out.println("-------------------------------------------------------------");
			System.out.println(pile.toString());
			System.out.println("-------------------------------------------------------------");
			System.out.println("\n");
			
			pile.depiler();
			
			System.out.println("\n");
			System.out.println("-------------------------------------------------------------");
			System.out.println(pile.toString());
			System.out.println("-------------------------------------------------------------");
			System.out.println("\n");
			
			System.out.println("\n");
			System.out.println("taille de la pile : " + pile.getTaille());
			
			System.out.println("fin du test de la pile !");
		  
		  
	  }
	
	
	
}
