package minijaja.compilateur;

import minijaja.jjtree.*;
import minijaja.exception.*;

public class CompileMiniJajaVisitor implements MiniJajaVisitor {
  
	public Object visit(SimpleNode node, Object data) throws MiniJajaVisitorException {
	  return null;
  }
  
  /**
   * Genere le JajaCode du noeud classe, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTclasse node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // init
	  ret += compdata.getAdresse() + " init;\n";
	  compdata.appendAdresse(1);
	  // dss
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // mma
	  ret += node.jjtGetChild(2).jjtAccept(this, data);
	  // rdss
	  compdata.setRetrait(true);
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  compdata.setRetrait(false);
	  // pop
	  ret += compdata.getAdresse() + " pop;\n";
	  compdata.appendAdresse(1);
	  // jcstop
	  ret += compdata.getAdresse() + " jcstop;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud ident, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTident node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // ident(i)
	  ret += compdata.getAdresse();
	  ret += " load(" + node.getValeur() + ");\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud decls, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTdecls node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  if(!compdata.isRetrait()){
		  // cdecls
		  
		  // ds
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
		  // dss
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  }else{
		  // crdecls
		  
		  // rdss
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // rds
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  }
	  
	  return ret;	
  }
  
  /**
   * Genere le JajaCode du noeud vnil, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTvnil node, Object data) throws MiniJajaVisitorException {
	  return "";
  }
  
  /**
   * Genere le JajaCode du noeud cst, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTcst node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";

	  if(!compdata.isRetrait()){
		  // ccst
		  
		  // e
		  ret += node.jjtGetChild(2).jjtAccept(this, data);
		  // new
		  ret += compdata.getAdresse();
		  ret += " new(";
		  ret += ((ASTident)node.jjtGetChild(1)).getValeur() + ",";
		  ret += node.jjtGetChild(0).jjtAccept(this, data) + ",";
		  ret += "cst,0";
		  ret += ");\n";
		  compdata.appendAdresse(1);
	  }else{
		  // crcst
		  
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // pop
		  ret += compdata.getAdresse() + " pop;\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud tableau, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTtableau node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  if(!compdata.isRetrait()){
		  // e
		  ret += node.jjtGetChild(2).jjtAccept(this, data);
		  // new
		  ret += compdata.getAdresse();
		  ret += " newarray(";
		  ret += ((ASTident)node.jjtGetChild(1)).getValeur() + ",";
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
		  ret += ");\n";
		  compdata.appendAdresse(1);
	  }else{
		  // crcst
		  
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // pop
		  ret += compdata.getAdresse() + " pop;\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud methode, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTmethode node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  if(!compdata.isRetrait()){
		  // cmethode

		  // push
		  ret += compdata.getAdresse() + " push(" + (compdata.getAdresse() + 3) + ");\n";
		  compdata.appendAdresse(1);
		  // new
		  ret += compdata.getAdresse();
		  ret += " new(";
		  ret += ((ASTident)node.jjtGetChild(1)).getValeur() + ",";
		  ret += node.jjtGetChild(0).jjtAccept(this, data) + ",";
		  ret += "meth,0);\n";
		  compdata.appendAdresse(1);
		  // goto
		  int addrgoto = compdata.getAdresse();
		  compdata.appendAdresse(1);
		  // ens
		  compdata.setNumEntete(0);
		  String ens = node.jjtGetChild(2).jjtAccept(this, data) + "";
		  // dvs
		  String dvs = node.jjtGetChild(3).jjtAccept(this, data) + "";
		  // iss
		  String iss = node.jjtGetChild(4).jjtAccept(this, data) + "";
		  // rdvs
		  compdata.setRetrait(true);
		  String rdvs = node.jjtGetChild(3).jjtAccept(this, data) + "";
		  compdata.setRetrait(false);
		  // cmethodeR
		  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTrien")){
			  // goto
			  ret += addrgoto + " goto(" + (compdata.getAdresse() + 3) + ");\n";
		  }else{
			  // goto
			  ret += addrgoto + " goto(" + (compdata.getAdresse() + 2) + ");\n";
		  }		  
		  // ens
		  ret += ens;
		  // dvs
		  ret += dvs;
		  // iss
		  ret += iss;
		  // rdvs
		  ret += rdvs;
		  // cmethodeR
		  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTrien")){
			  // push(0)
			  ret += compdata.getAdresse() + " push(0);\n";
			  compdata.appendAdresse(1); 
		  }
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // return
		  ret += compdata.getAdresse() + " return;\n";
		  compdata.appendAdresse(1);
	  }else{
		  // crmethode
		  
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // pop
		  ret += compdata.getAdresse() + " pop;\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud var, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTvar node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  if(!compdata.isRetrait()){
		  //cvar
		  
		  // e
		  ret += node.jjtGetChild(2).jjtAccept(this, data);
		  // new
		  ret += compdata.getAdresse();
		  ret += " new(";
		  ret += ((ASTident)node.jjtGetChild(1)).getValeur() + ",";
		  ret += node.jjtGetChild(0).jjtAccept(this, data) + ",";
		  ret += "var,0";
		  ret += ");\n";
		  compdata.appendAdresse(1);
	  }else{
		  // crvar
		  
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // pop
		  ret += compdata.getAdresse() + " pop;\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;	
  }
  
  
  /**
   * Genere le JajaCode du noeud vars, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTvars node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  if(!compdata.isRetrait()){
		  // cvars
		  
		  // dv
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
		  // dvs
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  }else{
		  // crvars
		  
		  // rdvs
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // rdv
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  }
	  
	  return ret;	
  }
  
  /**
   * Genere le JajaCode du noeud omega, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTomega node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // push
	  ret += compdata.getAdresse() + " push();\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud main, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTmain node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // dvs
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // iss
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // push
	  ret += compdata.getAdresse() + " push(0);\n";
	  compdata.appendAdresse(1);
	  // rdvs
	  compdata.setRetrait(true);
	  ret += node.jjtGetChild(0).jjtAccept(this, data) + "";
	  compdata.setRetrait(false);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud entetes, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTentetes node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  compdata.appendNumEntete(1);
	  // en
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // ens
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud enil, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTenil node, Object data) throws MiniJajaVisitorException {
	  return "";
  }
  
  /**
   * Genere le JajaCode du noeud entete, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTentete node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // new
	  ret += compdata.getAdresse();
	  ret += " new(";
	  ret += ((ASTident)node.jjtGetChild(1)).getValeur() + ",";
	  ret += node.jjtGetChild(0).jjtAccept(this, data) + ",";
	  ret += "var," + compdata.getNumEntete();
	  ret += ");\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud entete, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTinstrs node, Object data) throws MiniJajaVisitorException {
	  String ret = "";
	  
	  // is
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // iss
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  
	  return ret;	
  }
  
  /**
   * Genere le JajaCode du noeud inil, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTinil node, Object data) throws MiniJajaVisitorException {
	  return "";
  }
  
  /**
   * Genere le JajaCode du noeud retour, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTretour node, Object data) throws MiniJajaVisitorException {
	  String ret = "";
	  
	  // e
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud tantque, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTtantque node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // goto
	  int addrgoto = compdata.getAdresse();
	  // e
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // not
	  ret += compdata.getAdresse() + " not;\n";
	  compdata.appendAdresse(1);
	  // if
	  int addrif = compdata.getAdresse();
	  compdata.appendAdresse(1);
	  // iss
	  String iss = node.jjtGetChild(1).jjtAccept(this, data) + "";
	  // if
	  ret += addrif + " if(" + (compdata.getAdresse() + 1) + ");\n";
	  // iss
	  ret += iss;
	  // goto
	  ret += compdata.getAdresse() + " goto(" + addrgoto + ");\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud si, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTsi node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // if
	  int addrif = compdata.getAdresse();
	  compdata.appendAdresse(1);
	  // s1
	  String s1 = node.jjtGetChild(2).jjtAccept(this, data) + "";
	  // if
	  ret += addrif + " if(" + (compdata.getAdresse() + 1) + ");\n";
	  // s1
	  ret += s1;
	  // goto
	  int addrgoto = compdata.getAdresse();
	  compdata.appendAdresse(1);
	  // s
	  String s = node.jjtGetChild(1).jjtAccept(this, data) + "";
	  // goto
	  ret += addrgoto + " goto(" + (compdata.getAdresse()) + ");\n";
	  // s
	  ret += s;
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud appelI, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTappelI node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // lexp
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // invoke
	  ret += compdata.getAdresse();
	  ret += " invoke(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
	  compdata.appendAdresse(1);
	  // rlexp
	  compdata.setRetrait(true);
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  compdata.setRetrait(false);
	  // pop
	  ret += compdata.getAdresse();
	  ret += " pop;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud affectation, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTaffectation node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  // caffecte
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTident")){
		  // e
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // inc
		  ret += compdata.getAdresse();
		  ret += " store(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  // caffecteT
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTtab")){
		  // e1
		  ret += node.jjtGetChild(0).jjtGetChild(1).jjtAccept(this, data);
		  // e
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // ainc
		  ret += compdata.getAdresse();
		  ret += " astore(" + ((ASTident)((ASTtab)node.jjtGetChild(0)).jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud somme, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTsomme node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // csomme
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTident")){
		  // e
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // inc
		  ret += compdata.getAdresse();
		  ret += " inc(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  // csommeT
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTtab")){
		  // e1
		  ret += node.jjtGetChild(0).jjtGetChild(1).jjtAccept(this, data);
		  // e
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
		  // ainc
		  ret += compdata.getAdresse();
		  ret += " ainc(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud increment, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTincrement node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // cinc
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTident")){
		  // push(1)
		  ret += compdata.getAdresse() + " push(1);\n";
		  compdata.appendAdresse(1);
		  // inc
		  ret += compdata.getAdresse();
		  ret += " inc(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  // cincT
	  if(node.jjtGetChild(0).getClass().getSimpleName().equals("ASTtab")){
		  // e
		  ret += node.jjtGetChild(0).jjtGetChild(1).jjtAccept(this, data);
		  // push(1)
		  ret += compdata.getAdresse() + " push(1);\n";
		  compdata.appendAdresse(1);
		  // ainc
		  ret += compdata.getAdresse();
		  ret += " ainc(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
		  compdata.appendAdresse(1);
	  }
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud tab, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTtab node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // aload
	  ret += compdata.getAdresse();
	  ret += " aload(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  public Object visit(ASTlistexp node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";

	  if(!compdata.isRetrait()){
		  // clexp
		  
		  // exp
		  ret += node.jjtGetChild(0).jjtAccept(this, data);
		  // lexp
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  }else{
		  // crlexp
		  
		  // swap
		  ret += compdata.getAdresse() + " swap;\n";
		  compdata.appendAdresse(1);
		  // pop
		  ret += compdata.getAdresse() + " pop;\n";
		  compdata.appendAdresse(1);

		  // lexp
		  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  }
	  
	  return ret;
  }
  
  public Object visit(ASTexnil node, Object data) throws MiniJajaVisitorException {
	  return "";
  }
  
  public Object visit(ASTnon node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";

	  // e
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // inc
	  ret += compdata.getAdresse();
	  ret += " not;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  public Object visit(ASTneg node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // neg
	  ret += compdata.getAdresse();
	  ret += " neg;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  public Object visit(ASTet node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // and
	  ret += compdata.getAdresse();
	  ret += " and;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  public Object visit(ASTou node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // or
	  ret += compdata.getAdresse();
	  ret += " or;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  public Object visit(ASTegal node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // cmp
	  ret += compdata.getAdresse();
	  ret += " cmp;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  public Object visit(ASTinf node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // inc
	  ret += compdata.getAdresse();
	  ret += " inf;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud sup, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTsup node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // inc
	  ret += compdata.getAdresse();
	  ret += " sup;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud plus, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTplus node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // add
	  ret += compdata.getAdresse();
	  ret += " add;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud moins, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTmoins node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // sub
	  ret += compdata.getAdresse();
	  ret += " sub;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud mul, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTmult node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // mul
	  ret += compdata.getAdresse();
	  ret += " mul;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud div, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTdiv node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // e1
	  ret += node.jjtGetChild(0).jjtAccept(this, data);
	  // e
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // div
	  ret += compdata.getAdresse();
	  ret += " div;\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud vrai, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTvrai node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // vrai
	  ret += compdata.getAdresse() + " push(true);\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud faux, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTfaux node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // faux
	  ret += compdata.getAdresse() + " push(false);\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud appelE, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTappelE node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // lexp
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  // invoke
	  ret += compdata.getAdresse();
	  ret += " invoke(" + ((ASTident)node.jjtGetChild(0)).getValeur() + ");\n";
	  compdata.appendAdresse(1);
	  // rlexp
	  compdata.setRetrait(true);
	  ret += node.jjtGetChild(1).jjtAccept(this, data);
	  compdata.setRetrait(false);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud nbre, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTnbre node, Object data) throws MiniJajaVisitorException {
	  CompilateurData compdata = (CompilateurData)data;
	  String ret = "";
	  
	  // nbre(i)
	  ret += compdata.getAdresse() + " push(" + node.getValeur() + ");\n";
	  compdata.appendAdresse(1);
	  
	  return ret;
  }
  
  /**
   * Genere le JajaCode du noeud rien, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTrien node, Object data) throws MiniJajaVisitorException {
	  return "void";
  }
  
  /**
   * Genere le JajaCode du noeud entier, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTentier node, Object data) throws MiniJajaVisitorException {
	  return "entier";
  }
  
  /**
   * Genere le JajaCode du noeud booleen, en fonction de l'état du compilateur.
   * @param node Noeud à compiler
   * @param data Etat du compilateur (Adresse, Retrait)
   */
  public Object visit(ASTbooleen node, Object data) throws MiniJajaVisitorException {
	  return "booleen";
  }
}
