import java.awt.*;
import java.io.*;

/** La classe Maillon permet de modliser graphiquement 
 * un maillon d'une liste chaine en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class Maillon implements Serializable{
	private Maillon suivant;
	private Object info;
	private Point centre;
	private boolean selected;
	private int caseInfo;
	/** Construit un maillon vide au point de coordonne (0,0).
	 */
	public Maillon(){
		suivant=null;
		centre=new Point(0,0);
		info=null;
		selected=false;
		caseInfo=10;
	}
	/** Construit un maillon au point de coordonne (0,0) contenant un objet, .
	 */
	public Maillon(Object o){
		suivant=null;
		centre=new Point(0,0);
		info=o;
		selected=false;
		caseInfo=o.toString().length()*8+20;
	}
	/** Construit un maillon au point de coordonne (0,0) contenant un objet 
	 * et une rfrence sur le maillon vers lequel pointe ce maillon.
	 */
	public Maillon(Object o,Maillon svt){
		suivant=svt;
		centre=new Point(0,0);
		info=o;
		selected=false;
	}
	/** Renvoie le point de coordone du maillon.
	 */
	public Point getCentre(){
		return centre;
	}
	/** Renvoie la rfrence du maillon vers lequel pointe ce maillon.
	 */
	public Maillon getSuivant(){
		return suivant;
	}
	/** Renvoie l'objet contenu dans ce maillon.
	 */
	public Object getInfo(){
		return info;
	}
	/** Renvoie l'tat de slection de l'objet.
	 */
	public boolean getSelected(){
		return selected;
	}
	/** Renvoie la largeur en pixel de la chaine reprsentant les informations.
	 */
	public int getCaseInfo(){
		return caseInfo;
	}
	/** Affecte le point de coordone du maillon.
	 */
	public void setCentre(Point p){
		centre=p;
	}
	/** Affecte la rfrence du maillon vers lequel pointe ce maillon.
	 */
	public void setSuivant(Maillon m){
		suivant=m;
	}
	/** Affecte l'objet contenu dans ce maillon et recalcule 
	 * la largeur en pixel de la chaine reprsentant les informations.
	 */
	public void setInfo(Object o){
		info=o;
		caseInfo=o.toString().length()*8+20;
	}
	/** Affecte l'tat de slection de l'objet.
	 */
	public void setSelected(boolean b){
		selected=b;
	}
	/** Affecte la largeur en pixel de la chaine reprsentant les informations.
	 */
	public void setCaseInfo(int i){
		caseInfo=i;
	}
	/** Indique l'tat de slection de l'objet.
	 */
	public boolean isSelected(){
		return selected;
	}
	/** Indique si un point est inclus dans l'espace de dessin du maillon.
	 */
	public boolean isPointSurMaillon(Point p){
		if(p.x>centre.x && p.x<centre.x+caseInfo+20 
				&& p.y>centre.y-15 && p.y<centre.y+15){
			return true;
		}else{
			return false;
		}
	}
	/** Renvoie la largeur du maillon.
	 */
	public int largeurMaillon(){
		return caseInfo+20;
	}
	/** Renvoie la chaine de caractre reprsentant les informations du maillon.
	 */
	public String toString(){
		return info.toString();
	}
	/** Compare le maillon  un autre.
	 */
	public int compareTo(Maillon m){
		return this.getInfo().toString().compareTo(m.getInfo().toString());
	}
	/** Renvoie un rectangle reprsentant la surface occup par le maillon.
	 */
	public Rectangle occupeSurface(){
		int largeur=0,hauteur=30,x=centre.x,y=centre.y-15;
		largeur=this.largeurMaillon();
		if(this.getSuivant()==null){
			largeur=largeur+41;
		}else{
			if(this.getSuivant().getCentre().x==this.getCentre().x){
				largeur=largeur+10;
				hauteur=45;
			}else{
				if(this.getSuivant().getCentre().x>this.getCentre().x){
					largeur=this.getSuivant().getCentre().x-this.getCentre().x;
				}else{
					largeur=this.getCentre().x-this.getSuivant().getCentre().x+this.largeurMaillon()+3;
					x=this.getSuivant().getCentre().x+7;
					hauteur=45;
				}
			}
		}
		return new Rectangle(x,y,largeur,hauteur);
	}
	/** Dessine le maillon dans le contexte graphique spcifi au point de coordonne
	 * du maillon.
	 */
	public void paint(Graphics g){
		if(selected){
			g.setColor(Color.lightGray);
			g.fillRect(centre.x,centre.y-15,caseInfo+20,30);
			g.setColor(Color.black);
		}
		g.drawRect(centre.x,centre.y-15,caseInfo+20,30);
		g.drawLine(centre.x+caseInfo,centre.y-15,centre.x+caseInfo,centre.y+15);
		g.fillOval(centre.x+caseInfo+7,centre.y-3,6,6);		
		if(info!=null){
			g.drawString(info.toString(),centre.x+10,centre.y+3);
		}
		if(suivant==null){
			g.drawLine(centre.x+caseInfo+7,centre.y,centre.x+caseInfo+57,centre.y);
			g.drawLine(centre.x+caseInfo+57,centre.y-10,centre.x+caseInfo+57,centre.y+10);
			g.drawLine(centre.x+caseInfo+59,centre.y-7,centre.x+caseInfo+59,centre.y+7);
			g.drawLine(centre.x+caseInfo+61,centre.y-4,centre.x+caseInfo+61,centre.y+4);
		}else{
			if(suivant.getCentre().x>centre.x){
				g.drawLine(centre.x+caseInfo+7,centre.y,suivant.getCentre().x,suivant.getCentre().y);
				g.drawLine(suivant.getCentre().x-3,suivant.getCentre().y-3,suivant.getCentre().x,suivant.getCentre().y);
				g.drawLine(suivant.getCentre().x-3,suivant.getCentre().y+3,suivant.getCentre().x,suivant.getCentre().y);
				suivant.paint(g);
			}else{
				g.drawLine(centre.x+caseInfo+7,centre.y,centre.x+caseInfo+30,centre.y);
				g.drawLine(centre.x+caseInfo+30,centre.y,centre.x+caseInfo+30,centre.y+30);
				g.drawLine(centre.x+caseInfo+30,centre.y+30,suivant.centre.x+10,centre.y+30);
				g.drawLine(suivant.centre.x+10,centre.y+30,suivant.centre.x+10,centre.y+15);
				g.drawLine(suivant.centre.x+7,centre.y+18,suivant.centre.x+10,centre.y+15);
				g.drawLine(suivant.centre.x+13,centre.y+18,suivant.centre.x+10,centre.y+15);
			}
		}
	}
}
