import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

/** La classe ListeDoublementChainee permet de modliser graphiquement 
 * une liste doublement chaine en utilisant Swing.
 *  
 * @author Eric Beuque et Stphane Chenevoy
 *
 */
public class ListeDoublementChainee extends Liste{
	/** Construit une liste doublement chaine vide au point de coordonne (0,0).
	 */
	public ListeDoublementChainee(){
		super();
	}
	public boolean isPointSurTeteListe(Point p){
		if(p.x>this.getCentre().x-10 && p.x<this.getCentre().x+10 
				&& p.y>this.getCentre().y-10 && p.y<this.getCentre().y+10){
			return true;
		}else{
			return false;
		}
	}
	public void ajouterMaillon(Maillon m){
		MaillonDouble tmp=new MaillonDouble(m.getInfo());
		tmp.setSuivant(this.getTete());
		tmp.setPrecedent(null);
		if(tmp.getSuivant()!=null){
			((MaillonDouble)(tmp.getSuivant())).setPrecedent(tmp);
		}
		this.setTete(tmp);
		this.recalcCentreMaillon();
	}
	public void retirerMaillon(Maillon m){
		if(this.getTete()!=null){
			if(this.getTete()==m){
				this.retirerMaillon();
			}else{
				if(m.getSuivant()!=null){
					((MaillonDouble)m.getSuivant()).setPrecedent(((MaillonDouble)m).getPrecedent());
				}else{
					((MaillonDouble)m).getPrecedent().setSuivant(null);
				}
				if(((MaillonDouble)m).getPrecedent()!=null){
					((MaillonDouble)m).getPrecedent().setSuivant(((MaillonDouble)m).getSuivant());
				}else{
					((MaillonDouble)m.getSuivant()).setPrecedent(null);
				}
				
			}
		}
		this.recalcCentreMaillon();
	}
	public void retirerMaillon(){
		MaillonDouble m =((MaillonDouble)this.getTete());
		
		if(this.getTete()!=null){
				if(this.getTete().getSuivant()==this.getTete()){
					this.setTete(null);
				}else{
					this.setTete(m.getSuivant());
					((MaillonDouble)this.getTete()).setPrecedent(null);
				}
		}
		this.recalcCentreMaillon();
	}
	public void recalcCentreMaillon(){
		Maillon m;
		if(this.getTete()!=null){
			m=this.getTete();
			m.setCentre(new Point(this.getCentre().x+40,this.getCentre().y+40));
			while(m.getSuivant()!=null){
				m.getSuivant().setCentre(new Point(m.getCentre().x+m.largeurMaillon()+40,m.getCentre().y));
				m=m.getSuivant();
			}
		}
	}
	public void paint(Graphics g){
		if(this.getSelected()){
			g.setColor(Color.lightGray);
			g.fillRect(this.getCentre().x-10,this.getCentre().y-10,20,20);
			g.setColor(Color.black);
		}
		g.drawRect(this.getCentre().x-10,this.getCentre().y-10,20,20);
		g.fillOval(this.getCentre().x-3,this.getCentre().y-3,6,6);
		
		if(getEtendu()==true){
			if(this.getTete()==null){
				g.drawLine(this.getCentre().x,this.getCentre().y,this.getCentre().x+40,this.getCentre().y);
				g.drawLine(this.getCentre().x+40,this.getCentre().y-10,this.getCentre().x+40,this.getCentre().y+10);
				g.drawLine(this.getCentre().x+42,this.getCentre().y-7,this.getCentre().x+42,this.getCentre().y+7);
				g.drawLine(this.getCentre().x+44,this.getCentre().y-4,this.getCentre().x+44,this.getCentre().y+4);
			}else{
				g.drawLine(this.getCentre().x,this.getCentre().y,this.getTete().getCentre().x+10,this.getCentre().y);
				g.drawLine(this.getTete().getCentre().x+10,this.getCentre().y,this.getTete().getCentre().x+10,this.getTete().getCentre().y-15);
				g.drawLine(this.getTete().getCentre().x+7,this.getTete().getCentre().y-18,this.getTete().getCentre().x+10,this.getTete().getCentre().y-15);
				g.drawLine(this.getTete().getCentre().x+13,this.getTete().getCentre().y-18,this.getTete().getCentre().x+10,this.getTete().getCentre().y-15);
				this.getTete().paint(g);
			}
		}
	}
}
