// Maillon.h: interface for the Maillon class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAILLON_H__039B83EC_C895_4DDC_8B99_4621A5BF2A0F__INCLUDED_)
#define AFX_MAILLON_H__039B83EC_C895_4DDC_8B99_4621A5BF2A0F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <iostream.h>
#include "InfoTour.h"

class Maillon  
{
private:
	InfoTour info; // Information du tour
	Maillon* next; // Tour prcdent
public:
	Maillon(const InfoTour& inf);
	Maillon(const InfoTour& inf, Maillon* m);
	virtual ~Maillon();
	InfoTour& getInfo();
	// Renvoie le maillon suivant
	Maillon* getNext();
	// Attribue l'InfoTour
	void setInfo(const InfoTour& inf);
	// Attribue le tour prcdent
	void setNext(const Maillon* m);
	// Affectation d'un Maillon
	void operator = (const Maillon* m);
	friend ostream& operator << (ostream& out, const Maillon* m);
};

#endif // !defined(AFX_MAILLON_H__039B83EC_C895_4DDC_8B99_4621A5BF2A0F__INCLUDED_)
