// InfoTour.h: interface for the InfoTour class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INFOTOUR_H__8D8FA8B4_75A7_430D_BC2A_66E5FA35A594__INCLUDED_)
#define AFX_INFOTOUR_H__8D8FA8B4_75A7_430D_BC2A_66E5FA35A594__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <iostream.h>

class InfoTour  
{
private:
	int m_noJoueur; // Numro du joueur
	int m_ligS; // Ligne de dpart
	int m_colS; // Colonne de dpart
	int m_ligD; // Ligne d'arriv
	int m_colD; // Colonne d'arriv
public:
	InfoTour();
	InfoTour(int noJoueur, int ligS, int colS, int ligD, int colD);
	InfoTour(const InfoTour& inf);
	virtual ~InfoTour();
	// Renvoie le numro de joueur
	int getNoJoueur() const;
	// Renvoie la ligne de dpart
	int getLigS() const;
	// Renvoie la colonne de dpart
	int getColS() const;
	// Renvoie la ligne d'arriv
	int getLigD() const;
	// Renvoie la colonne d'arriv
	int getColD() const;
	// Affectation d'un InfoTour par copie
	void operator = (const InfoTour& inf);
	// Affichage
	friend ostream& operator << (ostream& out, const InfoTour& inf);
};

#endif // !defined(AFX_INFOTOUR_H__8D8FA8B4_75A7_430D_BC2A_66E5FA35A594__INCLUDED_)
