// Pile.cpp: implementation of the Pile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pile.h"
#include "Exception.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Pile::Pile()
{
	access=NULL;
}

Pile::~Pile()
{
	delete access;
}

InfoTour& Pile::getFisrtInfo() const
{
	return access->getInfo();
}

bool Pile::pileVide() const
{
	if(access){
		return false;	
	}else{
		return true;
	}
}

void Pile::empile(const InfoTour& info)
{
	access=new Maillon(info,access);
}

InfoTour& Pile::depile()
{
	if(access){
		Maillon* tmp;
		tmp=access;
		access=access->getNext();
		InfoTour* inf=new InfoTour(tmp->getInfo());
		delete tmp;
		return *inf;
	}
	throw new PileVideException;
}

ostream& operator << (ostream& out, const Pile& p)
{
	if(p.access){
		out << p.access;
	}
	return out;
}
