package serveur;

public class SafraTerminaison {
	
	public static final int STATE_PASSIVE = 0;
	public static final int STATE_ACTIVE = 1;
	
	public static final int COLOR_BLACK = 0;
	public static final int COLOR_WHITE = 1;
	
	private Serveur serveur;
	private boolean modeTerminaison;
	private boolean endTerminaison;
	
	// Pour la terminaison
	private int state;
	private int color;
	private int mc;
	
	public SafraTerminaison(Serveur serveur){
		this.serveur = serveur;
		mc = 0;
		modeTerminaison = false;
		endTerminaison = false;
	}
	
	public void setState(int state){
		this.state = state;
	}
	
	public int getState(){
		return this.state;
	}
	
	public void setColor(int color){
		this.color = color;
	}
	
	public int getColor(){
		return this.color;
	}
	
	public boolean isModeTerminaison(){
		return modeTerminaison;
	}
	
	public void setModeTerminaison(boolean modeTerminaison){
		this.modeTerminaison = modeTerminaison;
	}

	public boolean isEndTerminaison(){
		return endTerminaison;
	}
	
	public void setEndTerminaison(boolean endTerminaison){
		this.endTerminaison = endTerminaison;
	}
	
	public int getMc(){
		return this.mc;
	}
	
	public void doSend(){
		this.mc++;
	}
	
	public void doRecv(){
		this.state = STATE_ACTIVE;
		this.mc--;
		this.color = COLOR_BLACK;
	}
	
	public void doIdle(){
		this.state = STATE_PASSIVE;
	}
	
}
