package filtre;

import java.awt.image.BufferedImage;

import decoupage.Morceau;


/**
 * Contour - Traitement detection de contour.
 * 
 * @version 1.0 - 14/01/2008
 * @author Beuque & Cornevaux
 */
public class Contour extends Filtre {
	
	public Contour(Morceau morceau) {
		this.morceau = morceau;
	}
	
	
	
	
	
	
	/**
	 * traitementContour() - return un tableau des pixels traites.
	 * 
	 * @version 1.0 - 14/01/2008
	 * @author Beuque & Cornevaux
	 */
	public int[] traitementContour() {
		try {
			int dstPixels[] = contour(morceau.getWidth(), morceau.getHeight(), morceau.getPixelsTab());
			BufferedImage dst = new BufferedImage(morceau.getWidth(), morceau.getHeight(), BufferedImage.TYPE_INT_ARGB);
			dst.setRGB(0, 0, morceau.getWidth(), morceau.getHeight(), dstPixels, 0, morceau.getWidth());
			return dst.getRGB(0, 0, morceau.getWidth(), morceau.getHeight(), null, 0, morceau.getWidth());
		} catch (Exception e) {
			System.out.println("Erreur : " + e.toString());
		}
		return null;
	}

	
	/**
	 * contour() - 
	 * 
	 * @param width
	 * @param height
	 * @param srcPixels
	 * @return
	 */
	public static int[] contour(int width, int height, int srcPixels[]) {
		int GX[][] = new int[3][3];
		int GY[][] = new int[3][3];
		GX[0][0] = -1;
		GX[0][1] = 0;
		GX[0][2] = 1;
		GX[1][0] = -2;
		GX[1][1] = 0;
		GX[1][2] = 2;
		GX[2][0] = -1;
		GX[2][1] = 0;
		GX[2][2] = 1;

		GY[0][0] = 1;
		GY[0][1] = 2;
		GY[0][2] = 1;
		GY[1][0] = 0;
		GY[1][1] = 0;
		GY[1][2] = 0;
		GY[2][0] = -1;
		GY[2][1] = -2;
		GY[2][2] = -1;

		int dstPixels[] = new int[srcPixels.length];
		for (int Y = 0; Y < height; Y++) {
			for (int X = 0; X < width; X++) {
				int red = 0, green = 0, blue = 0;
				int I, J;
				int sumX = 0, redSumX = 0, greenSumX = 0, blueSumX = 0;
				int sumY = 0, redSumY = 0, greenSumY = 0, blueSumY = 0;
				;

///*				
				if (Y == 0 || Y == height - 1) {
					red = 0;
					green = 0;
					blue = 0;
				} else if (X == 0 || X == width - 1) {
					red = 0;
					green = 0;
					blue = 0;
				} else {
//*/
					for (I = -1; I <= 1; I++)
						for (J = -1; J <= 1; J++) {
							redSumX += (int) (getRed(srcPixels[X + I + (Y + J)
									* width]) * GX[I + 1][J + 1]);
							greenSumX += (int) (getGreen(srcPixels[X + I
									+ (Y + J) * width]) * GX[I + 1][J + 1]);
							blueSumX += (int) (getBlue(srcPixels[X + I
									+ (Y + J) * width]) * GX[I + 1][J + 1]);
						}

					for (I = -1; I <= 1; I++)
						for (J = -1; J <= 1; J++) {
							redSumY += (int) (getRed(srcPixels[X + I + (Y + J)
									* width]) * GY[I + 1][J + 1]);
							greenSumY += (int) (getGreen(srcPixels[X + I
									+ (Y + J) * width]) * GY[I + 1][J + 1]);
							blueSumY += (int) (getBlue(srcPixels[X + I
									+ (Y + J) * width]) * GY[I + 1][J + 1]);
						}

					red = Math.abs(redSumX) + Math.abs(redSumY);
					green = Math.abs(greenSumX) + Math.abs(greenSumY);
					blue = Math.abs(blueSumX) + Math.abs(blueSumY);
				}

				if (red > 255)
					red = 255;
				if (red < 0)
					red = 0;
				if (green > 255)
					green = 255;
				if (green < 0)
					green = 0;
				if (blue > 255)
					blue = 255;
				if (blue < 0)
					blue = 0;

				red = 255 - red;
				green = 255 - green;
				blue = 255 - blue;

				dstPixels[X + Y * width] = 0xFF000000 | (red << 16)
						| (green << 8) | blue;
			}
		}

		return dstPixels;
	}
	
	
	
	
	/**
	 * getRed() - 
	 * 
	 * @param pixel
	 * @return
	 */
	public static int getRed(int pixel) {
		int tmp = pixel & 0x00FF0000;
		return tmp >> 16;
	}

	
	/**
	 * getGreen() -
	 * 
	 * @param pixel
	 * @return
	 */
	public static int getGreen(int pixel) {
		int tmp = pixel & 0x0000FF00;
		return tmp >> 8;
	}

	
	/**
	 * getBlue() -
	 * 
	 * @param pixel
	 * @return
	 */
	public static int getBlue(int pixel) {
		int tmp = pixel & 0x000000FF;
		return tmp;
	}
}