package admin;

import serveur.ServeurInfos;
import tools.Loggeur;

public class AdminLauncher implements AdminActionListener {
	
	private Admin admin;
	
	public void run(AdminInfos adminInfos, ServeurInfos serveurInfos){
		try {			
			admin = new Admin(adminInfos);
			admin.addAdminActionListener(this);
			admin.init();
			admin.setServeur(serveurInfos);
			admin.demarrerTerminaison();
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("[ERREUR] " + e.getClass().getSimpleName() + " : "+ e.getMessage());
		}
	}
	
	public void onFinTerminaison() {
		try {
			Loggeur.writeLog("Admin", "La plate-forme a bien été arreté !");
			admin.destroy();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		if(args.length != 6){
			System.out.println("Usage : nom hote port nomServeur hoteServeur portServeur");
			System.out.println("\tnom : Nom de l'admin");
			System.out.println("\thote : Nom d'hote de l'admin");
			System.out.println("\tport : Port de l'admin (RMI Registry)(défaut: 1099)");
			System.out.println("\tnomServeur : Nom du serveur");
			System.out.println("\thoteServeur : Nom de l'hote du serveur");
			System.out.println("\tportServeur : Port du serveur");
			return;
		}
		
		AdminInfos adminInfos;
		adminInfos = new AdminInfos(args[0], args[1], Integer.parseInt(args[2]));
		
		ServeurInfos serveurInfos;
		serveurInfos = new ServeurInfos(args[3], args[4], Integer.parseInt(args[5]));
		
		AdminLauncher admin = new AdminLauncher();
		admin.run(adminInfos, serveurInfos);
		
	}
}
