/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8-*- */

#include <stdio.h>
#include <stdlib.h>

#include "fonctionsSocket.h"
#include "joueur-siam.h"

int main(int argc, char **argv){
	
	int res;
	char *name = "ebeuque";
	char *machine;
	short port = 8006;

	JoueurSiam joueur;

	/* Recuperation des parametres */
	if(argc!=3 && argc!=5){
		printf("Usage: %s arbitre_machine arbitre_port [me_port, me_name]\n",
		       argv[0]);
		return -1;
	}
	if(argc == 5){
		name = argv[4];
		port = atoi(argv[3]);
	}

	res = gethostname(machine, TAIL_CHAIN);

	/* Creation du joueur */
	res = joueur_siam_init (&joueur, name, machine, port);
	if (res<0){
		joueur_siam_destroy (&joueur);
		return -1;
	}
	
	/* Connexion a l'arbitre */
	res = joueur_siam_connexion_arbitre (&joueur, 
					     argv[1], atoi(argv[2]));
	if (res<0){
		joueur_siam_destroy (&joueur);
		return -1;
	}

	/* IDENTIFICATION vers l'arbitre */
	res = joueur_siam_identification (&joueur);
	if (res<0){
		joueur_siam_destroy (&joueur);
		return -1;
	}

	/* Tant que le tournoi n'est pas fini */
	do {
		printf("\nJeu --> Nouvelle partie.\n");
		
		/* PARTIE demandee l'arbitre */
		res = joueur_siam_demande_partie (&joueur);
		if (res<0){
			joueur_siam_destroy (&joueur);
			return -1;
		}
		
		if (joueur.fin_tournoi == FAUX){

			res = joueur_siam_connexion_adversaire (&joueur);
			if (res<0){
				joueur_siam_destroy (&joueur);
				return -1;
			}
			
			/* Tant que la partie n'est pas fini */
			do{	
				if(joueur.type_animal == ELEPH){
					res = joueur_siam_joue_coup(&joueur);
					if (res != 0){
						joueur.fin_partie = VRAI;
					}
				}else{
					res = joueur_siam_attend_coup_adverse(&joueur);
					if (res != 0){
						joueur.fin_partie = VRAI;
					}
				}
				
				if(joueur.fin_partie == FAUX){
					if(joueur.type_animal == RHINO){
						res = joueur_siam_joue_coup(&joueur);
						if (res != 0){
							joueur.fin_partie = VRAI;
						}
					}else{
						res = joueur_siam_attend_coup_adverse(&joueur);
						if (res != 0){
							joueur.fin_partie = VRAI;
						}
					}
				}				
			}while(joueur.fin_partie == FAUX);
			
			res = joueur_siam_deconnexion_adversaire (&joueur);
			if (res<0){
				joueur_siam_destroy (&joueur);
				return -1;
			}
			printf("Jeu --> Fin de la partie.\n");
		}
		
	}while(joueur.fin_tournoi == FAUX);
	printf("\nJeu --> Fin du tournoi.\n");
	
	joueur_siam_destroy (&joueur);
	
	return 0;
}
