package server;

import java.io.Serializable;

/**
 * Classe de réponse du serveur de certificat, retourne le certificat demandé
 * @author cmoutenet
 *
 */
public class CertificatReponse implements Serializable {

	private static final long serialVersionUID = -8009931223890084319L;
	/** Certificat serveur ou client suivant la demande antérieure */
	private final String certificat;

	/**
	 * COnstructeur
	 * @param certificat Certificat réponse
	 */
	public CertificatReponse(String certificat) {
		this.certificat = certificat;
	}

	/**
	 * Retourne le certificat
	 * @return
	 */
	public String getCertificat() {
		return certificat;
	}
}
