package relais;

import javax.jms.*;

import server.CertificatReponse;
import server.DemandeCertificatClient;
import server.DemandeCertificatServeur;

public class QueueRelaisServeur implements MessageListener {

	private final MessageProducer producer;
	private final MessageConsumer consumer;
	private final QueueSession queueSession;
	private final RelaisServer serveur;

	public QueueRelaisServeur(RelaisServer serveur, Queue queue,
			QueueConnectionFactory qcf) throws JMSException {
		this.serveur = serveur;
		QueueConnection qc = qcf.createQueueConnection();
		// Mode transactionnelle, avec acquitement manuel
		queueSession = qc.createQueueSession(false, Session.CLIENT_ACKNOWLEDGE);
		consumer = queueSession.createConsumer(queue);
		QueueSession session = qc.createQueueSession(false,
				Session.CLIENT_ACKNOWLEDGE);
		producer = session.createProducer(queue);

		consumer.setMessageListener(this);
		qc.start();
	}

	public void demanderCertificatServeur() throws JMSException {
		DemandeCertificatServeur demande = new DemandeCertificatServeur();
		ObjectMessage msg = queueSession.createObjectMessage();
		msg.setObject(demande);
		producer.send(msg);
		System.out.println("Demande certificat serveur envoyée");
	}

	public void demanderCertificatClient(String openSSLReq) throws JMSException {
		DemandeCertificatClient demande = new DemandeCertificatClient(
				openSSLReq);
		ObjectMessage msg = queueSession.createObjectMessage();
		msg.setObject(demande);
		producer.send(msg);
		System.out.println("Demande certificat client envoyée");
	}

	public void onMessage(Message msg) {
		//System.out.println("Message " + msg);
		ObjectMessage msgObj = (ObjectMessage) msg;
		try {
			Object obj = msgObj.getObject();
			if (obj instanceof CertificatReponse) {
				String certif = ((CertificatReponse) obj).getCertificat();
				serveur.retournerCertificat(certif);
				msg.acknowledge();
			}
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}

	public void close() {
		try {
			queueSession.close();
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}
}
