package server;

import java.io.Serializable;

import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

/**
 * Message serveur prêt contenant les références pour ce connecter à la queue
 * @author cmoutenet
 */
public class ServeurPret implements Serializable {

	private static final long serialVersionUID = 4984795586139267149L;

	private final Queue queueAddress;
	private final QueueConnectionFactory queueConnexionFactory;

	/**
	 * Constructeur
	 * @param queue Référence de la queue
	 * @param queueConnexionFactory Référence du connexionFactory de la queue
	 */
	public ServeurPret(Queue queue,
			QueueConnectionFactory queueConnexionFactory) {
		this.queueAddress = queue;
		this.queueConnexionFactory = queueConnexionFactory;
	}

	/**
	 * Retourne la queue
	 * @return
	 */
	public Queue getQueue() {
		return queueAddress;
	}

	/**
	 * Connexion factory de la queue
	 * @return
	 */
	public QueueConnectionFactory getQueueConnexionFactory() {
		return queueConnexionFactory;
	}

}
