import java.io.*;
import java.util.Date;

class MatriceJavaThread
{
  public static void main(String[] args) throws IOException, InterruptedException
  {
    int mSize;
    int[][] matrix1;
    int[][] matrix2;
    int[][] matrix3;
    int nbThread;

    int i, j;

    if (args.length < 2) {
      System.out.println("USAGE : m_size nb_threads [anything -v]");
      System.out.println("        m_size : size of the matrice");
      System.out.println("        nb_threads : number of threads");
      System.out.println("        -v : verbose");
      return;
    }

    // Début du chrono
		Date debut = new Date();

    mSize = Integer.parseInt(args[0]);
		nbThread = Integer.parseInt(args[1]);

    // Creation des matrices
    matrix1 = new int[mSize][mSize];
    matrix2 = new int[mSize][mSize];
    matrix3 = new int[mSize][mSize];
    for(i=0;i<mSize;i++){
      for(j=0;j<mSize;j++){
        matrix1[i][j] = i+j+1;
        matrix2[i][j] = i+j+1;
        matrix3[i][j] = 0;
      }
    }
    
    ProduitMatrice[] tab = new ProduitMatrice[nbThread];
    CurrentLig current = new CurrentLig(-1);
		for (i = 0; i < nbThread; i++) {
			tab[i] = new ProduitMatrice(mSize, matrix1, matrix2, matrix3, current);
		}
		for (i = 0; i < nbThread; i++) {
			tab[i].start();
		}
		for (i = 0; i < nbThread; i++) {
			tab[i].join();
		}

    // Affichage du resultat
    if(args.length == 3){
        for(i=0;i<mSize;i++){
	       System.out.print("[");
	        for(j=0;j<mSize;j++){
	          System.out.print("["+ matrix3[i][j] + "]");
	        }
	        System.out.print("]\n");
        }
    }

    // Fin du chrono
		Date duree = new Date(new Date().getTime() - debut.getTime());
		double realtime = (duree.getTime() / 1000.0);
    System.out.println(mSize + ";" + nbThread + ";JavaThread;" + realtime);
  }
}

class ProduitMatrice extends Thread
{
   private int mSize;
   private CurrentLig current;

   private int[][] matrix1, matrix2, matrix3;

   public ProduitMatrice(int m, int[][] m1, int[][] m2, int[][] m3, CurrentLig cur) {
      current=cur;     
      mSize=m;
      matrix1=m1;
      matrix2=m2;
      matrix3=m3;
   }

   public void run(){
      int i, j, k;
      
      do{

        synchronized(current){
          current.lig++;
          i=current.lig;
        }

        if(i<mSize){
          for(j=0;j<mSize;j++){
	          for(k=0;k<mSize;k++){
	            matrix3[i][j] += matrix1[i][k] * matrix2[k][j];
	          }
          }
        }
      }while(i<mSize);
   }
}

class CurrentLig {
  public int lig;

  public CurrentLig(int lig){
    this.lig = lig;
  }
}
