#!/bin/bash

export JAVA_HOME=/home/riku/Informatique/Outils/j2ee/jdk1.6.0
export PATH=$JAVA_HOME/bin:/usr/local/bin:/usr/bin:/bin:/usr/bin/X11:/usr/games

if test $# -ne 4
then
    echo "USAGE : $0 min max incr nb_time"
    echo "        min : min of thread number"
    echo "        max : max of thread number"
    echo "        incr : increment of the thread number"
    echo "        nb_time : number of time"
    exit -1
fi

test_name="creation"
TestName="Creation"

c_impl="c_pthreads c_openmp"
java_impl="JavaThread"
csharp_impl="CSharpThread"

echo $JAVA_HOME
echo -e "nb_threads;used_library;exec_time;average" > result.csv

for ((nbthread=$1;nbthread<=$2;nbthread+=$3))
do

    echo "Doing for creation of $nbthread thread(s)"

    # Implementation en C
    for impl in $c_impl
    do

        # Option du compilateur
        case $impl in
        "c_pthreads") comp_opt=" -pthread";;
        "c_openmp") comp_opt=" -fopenmp";;
        *) comp_opt="";;
        esac

        echo "    with $impl -opt:$comp_opt at `date +%H:%M:%S`"


        # Compilation et lancement
        (
            cd $impl
            gcc -g -Wall -std=c99 -ansi -pedantic -O3 $comp_opt -o "${test_name}_${impl}" "${test_name}_${impl}.c"
            # Nombre de fois
            for ((time=1;time<=$4;time+=1))
            do
                ./${test_name}_${impl} $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr "${test_name}_${impl}" *~
        )
    done

    # Implementation en JAVA
    for impl in $java_impl
    do
        echo "    with $impl at `date +%H:%M:%S`"

        # Compilation et lancement
        (
            cd $impl
            javac "${TestName}${impl}.java"
            # Nombre de fois
            for ((time=1;time<=$4;time+=1))
            do
                java "${TestName}${impl}" $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr *.class *~
        )
    done

    # Implementation en CSHARP
    for impl in $csharp_impl
    do
        echo "    with $impl at `date +%H:%M:%S`"
        
        # Compilation et lancement
        (
            cd $impl
            mcs "${TestName}${impl}.cs"
            # Nombre de fois
            for ((time=1;time<=$4;time+=1))
            do
                mono "./${TestName}${impl}.exe" $nbthread >> ../result.csv
            done
            # Nettoyage
            rm -fr "${TestName}${impl}.exe" *~
        )
    done

done

rm -fr *~
