/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.List;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;

public abstract class RecursiveAction
extends ForkJoinTask<Void> {
    protected abstract void compute();

    public static void forkJoin(RecursiveAction t1, RecursiveAction t2) {
        ((ForkJoinWorkerThread)Thread.currentThread()).doForkJoin(t1, t2);
    }

    public static void forkJoin(RecursiveAction[] tasks) {
        int last;
        Throwable ex = null;
        for (int i = last = tasks.length - 1; i >= 0; --i) {
            RecursiveAction t = tasks[i];
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if (t.exec() || ex != null) continue;
            ex = RecursiveAction.getException(t);
        }
        boolean pop = true;
        for (int i = 1; i <= last; ++i) {
            boolean ok;
            RecursiveAction t = tasks[i];
            if (t == null) continue;
            if (ex != null) {
                t.cancel();
            }
            if (pop && (pop = ForkJoinWorkerThread.removeIfNextLocalTask(t))) {
                ok = t.exec();
            } else {
                t.quietlyJoin();
                ok = t.completedNormally();
            }
            if (ok || ex != null) continue;
            ex = RecursiveAction.getException(t);
        }
        if (ex != null) {
            RecursiveAction.rethrowException(ex);
        }
    }

    public static void forkJoin(List<? extends RecursiveAction> tasks) {
        int last;
        Throwable ex = null;
        for (int i = last = tasks.size() - 1; i >= 0; --i) {
            RecursiveAction t = tasks.get(i);
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if (t.exec() || ex != null) continue;
            ex = RecursiveAction.getException(t);
        }
        boolean pop = true;
        for (int i = 1; i <= last; ++i) {
            boolean ok;
            RecursiveAction t = tasks.get(i);
            if (t == null) continue;
            if (ex != null) {
                t.cancel();
            }
            if (pop && (pop = ForkJoinWorkerThread.removeIfNextLocalTask(t))) {
                ok = t.exec();
            } else {
                t.quietlyJoin();
                ok = t.completedNormally();
            }
            if (ok || ex != null) continue;
            ex = RecursiveAction.getException(t);
        }
        if (ex != null) {
            RecursiveAction.rethrowException(ex);
        }
    }

    @Override
    public final Void rawResult() {
        return null;
    }

    @Override
    public final Void forkJoin() {
        if (this.status >= 0) {
            try {
                this.compute();
                this.setDone();
                return null;
            }
            catch (Throwable rex) {
                this.setDoneExceptionally(rex);
            }
        }
        return (Void)this.reportAsForkJoinResult();
    }

    @Override
    final boolean exec() {
        if (this.status >= 0) {
            try {
                this.compute();
                this.setDone();
                return true;
            }
            catch (Throwable rex) {
                this.setDoneExceptionally(rex);
            }
        }
        return false;
    }

    final boolean rawExec() {
        try {
            this.compute();
            this.setDone();
            return true;
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            return false;
        }
    }
}

