/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import jsr166y.forkjoin.AsyncAction;

public abstract class BinaryAsyncAction
extends AsyncAction {
    private BinaryAsyncAction parent;
    private BinaryAsyncAction sibling;

    protected BinaryAsyncAction() {
    }

    public final void linkSubtasks(BinaryAsyncAction x, BinaryAsyncAction y) {
        x.parent = y.parent = this;
        x.sibling = y;
        y.sibling = x;
    }

    protected void onFinish(BinaryAsyncAction x, BinaryAsyncAction y) {
    }

    protected boolean onException() {
        return true;
    }

    public void linkAndForkSubtasks(BinaryAsyncAction x, BinaryAsyncAction y) {
        this.linkSubtasks(x, y);
        y.fork();
        x.fork();
    }

    @Override
    public final void finish() {
        BinaryAsyncAction a = this;
        while (true) {
            BinaryAsyncAction s = a.sibling;
            BinaryAsyncAction p = a.parent;
            a.sibling = null;
            a.parent = null;
            a.setDone();
            if (p == null || p.casStatus(0, 1)) break;
            try {
                p.onFinish(a, s);
            }
            catch (Throwable rex) {
                p.doFinishExceptionally(rex);
                return;
            }
            a = p;
        }
    }

    @Override
    public final void finishExceptionally(Throwable ex) {
        if (!(ex instanceof RuntimeException) && !(ex instanceof Error)) {
            throw new IllegalArgumentException(ex);
        }
        this.doFinishExceptionally(ex);
    }

    private void doFinishExceptionally(Throwable ex) {
        BinaryAsyncAction a = this;
        while (a.status != -3) {
            a.setDoneExceptionally(ex);
            BinaryAsyncAction s = a.sibling;
            if (s != null) {
                s.cancel();
            }
            if (a.onException() && (a = a.parent) != null) continue;
            break;
        }
    }

    public final BinaryAsyncAction getParent() {
        return this.parent;
    }

    public BinaryAsyncAction getSibling() {
        return this.sibling;
    }

    @Override
    public void reinitialize() {
        this.sibling = null;
        this.parent = null;
        super.reinitialize();
    }

    @Override
    final boolean exec() {
        if (this.status >= 0) {
            try {
                this.compute();
            }
            catch (Throwable rex) {
                this.doFinishExceptionally(rex);
            }
        }
        return false;
    }
}

