/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.forkjoin.CommonOps;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.PAS;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelArrayWithBounds;
import jsr166y.forkjoin.ParallelArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelArrayWithFilter;
import jsr166y.forkjoin.ParallelArrayWithLongMapping;
import jsr166y.forkjoin.ParallelArrayWithMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithBounds;
import jsr166y.forkjoin.ParallelDoubleArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithFilter;
import jsr166y.forkjoin.ParallelDoubleArrayWithLongMapping;
import jsr166y.forkjoin.ParallelDoubleArrayWithMapping;
import jsr166y.forkjoin.ParallelLongArrayWithBounds;
import jsr166y.forkjoin.ParallelLongArrayWithDoubleMapping;
import jsr166y.forkjoin.ParallelLongArrayWithFilter;
import jsr166y.forkjoin.ParallelLongArrayWithLongMapping;
import jsr166y.forkjoin.ParallelLongArrayWithMapping;

public abstract class AbstractParallelAnyArray {
    final ForkJoinExecutor ex;
    final int origin;
    int fence;
    int threshold;

    AbstractParallelAnyArray(ForkJoinExecutor ex, int origin, int fence) {
        this.ex = ex;
        this.origin = origin;
        this.fence = fence;
    }

    public int size() {
        if (!this.hasFilter()) {
            return this.fence - this.origin;
        }
        PAS.FJCountSelected f = new PAS.FJCountSelected(this, this.origin, this.fence, null);
        this.ex.invoke(f);
        return f.count;
    }

    public int anyIndex() {
        if (!this.hasFilter()) {
            return this.origin < this.fence ? this.origin : -1;
        }
        AtomicInteger result = new AtomicInteger(-1);
        PAS.FJSelectAny f = new PAS.FJSelectAny(this, this.origin, this.fence, null, result);
        this.ex.invoke(f);
        return result.get();
    }

    public boolean isEmpty() {
        return this.anyIndex() < 0;
    }

    final int computeThreshold() {
        int n = this.fence - this.origin;
        int p = this.ex.getParallelismLevel();
        this.threshold = p > 1 ? 1 + n / (p << 3) : n;
        return this.threshold;
    }

    final int getThreshold() {
        int t = this.threshold;
        if (t == 0) {
            t = this.computeThreshold();
        }
        return t;
    }

    Object[] ogetArray() {
        return null;
    }

    double[] dgetArray() {
        return null;
    }

    long[] lgetArray() {
        return null;
    }

    abstract Object oget(int var1);

    abstract double dget(int var1);

    abstract long lget(int var1);

    boolean hasMap() {
        return false;
    }

    boolean hasFilter() {
        return false;
    }

    boolean isSelected(int index) {
        return true;
    }

    void leafApply(int lo, int hi, Ops.Procedure procedure) {
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            procedure.op(this.oget(i));
        }
    }

    void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            procedure.op(this.dget(i));
        }
    }

    void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            procedure.op(this.lget(i));
        }
    }

    Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
        boolean gotFirst = false;
        Object r = base;
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            Object x = this.oget(i);
            if (!gotFirst) {
                gotFirst = true;
                r = x;
                continue;
            }
            r = reducer.op(r, x);
        }
        return r;
    }

    double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
        boolean gotFirst = false;
        double r = base;
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            double x = this.dget(i);
            if (!gotFirst) {
                gotFirst = true;
                r = x;
                continue;
            }
            r = reducer.op(r, x);
        }
        return r;
    }

    long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
        boolean gotFirst = false;
        long r = base;
        for (int i = lo; i < hi; ++i) {
            if (!this.isSelected(i)) continue;
            long x = this.lget(i);
            if (!gotFirst) {
                gotFirst = true;
                r = x;
                continue;
            }
            r = reducer.op(r, x);
        }
        return r;
    }

    void leafTransfer(int lo, int hi, Object[] dest, int offset) {
        for (int i = lo; i < hi; ++i) {
            dest[offset++] = this.oget(i);
        }
    }

    void leafTransfer(int lo, int hi, double[] dest, int offset) {
        for (int i = lo; i < hi; ++i) {
            dest[offset++] = this.dget(i);
        }
    }

    void leafTransfer(int lo, int hi, long[] dest, int offset) {
        for (int i = lo; i < hi; ++i) {
            dest[offset++] = this.lget(i);
        }
    }

    void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
        for (int i = loIdx; i < hiIdx; ++i) {
            dest[offset++] = this.oget(indices[i]);
        }
    }

    void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
        for (int i = loIdx; i < hiIdx; ++i) {
            dest[offset++] = this.dget(indices[i]);
        }
    }

    void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
        for (int i = loIdx; i < hiIdx; ++i) {
            dest[offset++] = this.lget(indices[i]);
        }
    }

    final int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
        int k = 0;
        for (int i = lo; i < hi; ++i) {
            if (this.isSelected(i) != positive) continue;
            indices[lo + k++] = i;
        }
        return k;
    }

    abstract int leafMoveSelected(int var1, int var2, int var3, boolean var4);

    abstract void leafMoveByIndex(int[] var1, int var2, int var3, int var4);

    final Object[] allObjects(Class elementType) {
        Object[] dest;
        if (this.hasFilter()) {
            if (elementType == null) {
                elementType = !this.hasMap() ? this.ogetArray().getClass().getComponentType() : Object.class;
            }
            PAS.FJOSelectAllDriver r = new PAS.FJOSelectAllDriver(this, elementType);
            this.ex.invoke(r);
            return r.results;
        }
        int n = this.fence - this.origin;
        if (this.hasMap()) {
            dest = elementType == null ? new Object[n] : (Object[])Array.newInstance(elementType, n);
            this.ex.invoke(new PAS.FJOMap(this, this.origin, this.fence, null, dest, -this.origin));
        } else {
            Object[] array = this.ogetArray();
            if (elementType == null) {
                elementType = array.getClass().getComponentType();
            }
            dest = (Object[])Array.newInstance(elementType, n);
            System.arraycopy(array, this.origin, dest, 0, n);
        }
        return dest;
    }

    final double[] allDoubles() {
        if (this.hasFilter()) {
            PAS.FJDSelectAllDriver r = new PAS.FJDSelectAllDriver(this);
            this.ex.invoke(r);
            return r.results;
        }
        int n = this.fence - this.origin;
        double[] dest = new double[n];
        if (this.hasMap()) {
            this.ex.invoke(new PAS.FJDMap(this, this.origin, this.fence, null, dest, -this.origin));
        } else {
            double[] array = this.dgetArray();
            System.arraycopy(array, this.origin, dest, 0, n);
        }
        return dest;
    }

    final long[] allLongs() {
        if (this.hasFilter()) {
            PAS.FJLSelectAllDriver r = new PAS.FJLSelectAllDriver(this);
            this.ex.invoke(r);
            return r.results;
        }
        int n = this.fence - this.origin;
        long[] dest = new long[n];
        if (this.hasMap()) {
            this.ex.invoke(new PAS.FJLMap(this, this.origin, this.fence, null, dest, -this.origin));
        } else {
            long[] array = this.lgetArray();
            System.arraycopy(array, this.origin, dest, 0, n);
        }
        return dest;
    }

    void boundsCheck(int lo, int hi) {
        if (lo > hi) {
            throw new IllegalArgumentException(this.origin + " > " + this.fence);
        }
        if (lo < 0) {
            throw new ArrayIndexOutOfBoundsException(this.origin);
        }
        if (hi - lo > this.fence - this.origin) {
            throw new ArrayIndexOutOfBoundsException(this.fence);
        }
    }

    void leafTransform(int l, int h, Ops.Op op) {
    }

    void leafIndexMap(int l, int h, Ops.IntToObject op) {
    }

    void leafBinaryIndexMap(int l, int h, Ops.IntAndObjectToObject op) {
    }

    void leafGenerate(int l, int h, Ops.Generator generator) {
    }

    void leafFill(int l, int h, Object value) {
    }

    void leafCombineInPlace(int lo, int hi, Object[] other, int otherOffset, Ops.BinaryOp combiner) {
    }

    void leafCombineInPlace(int lo, int hi, ParallelArrayWithMapping other, int otherOffset, Ops.BinaryOp combiner) {
    }

    void leafTransform(int l, int h, Ops.DoubleOp op) {
    }

    void leafIndexMap(int l, int h, Ops.IntToDouble array) {
    }

    void leafBinaryIndexMap(int l, int h, Ops.IntAndDoubleToDouble op) {
    }

    void leafGenerate(int l, int h, Ops.DoubleGenerator generator) {
    }

    void leafFill(int l, int h, double value) {
    }

    void leafCombineInPlace(int lo, int hi, double[] other, int otherOffset, Ops.BinaryDoubleOp combiner) {
    }

    void leafCombineInPlace(int lo, int hi, ParallelDoubleArrayWithDoubleMapping other, int otherOffset, Ops.BinaryDoubleOp combiner) {
    }

    void leafTransform(int l, int h, Ops.LongOp op) {
    }

    void leafIndexMap(int l, int h, Ops.IntToLong array) {
    }

    void leafBinaryIndexMap(int l, int h, Ops.IntAndLongToLong op) {
    }

    void leafGenerate(int l, int h, Ops.LongGenerator generator) {
    }

    void leafFill(int l, int h, long value) {
    }

    void leafCombineInPlace(int lo, int hi, long[] other, int otherOffset, Ops.BinaryLongOp combiner) {
    }

    void leafCombineInPlace(int lo, int hi, ParallelLongArrayWithLongMapping other, int otherOffset, Ops.BinaryLongOp combiner) {
    }

    static <T, U, V, W> Ops.IntAndObjectToObject<T, V> indexedMapper(final Ops.BinaryOp<? super T, ? super U, ? extends V> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndObjectToObject<T, V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, T a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <T, U, W> Ops.IntAndObjectToDouble<T> indexedMapper(final Ops.ObjectAndObjectToDouble<? super T, ? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndObjectToDouble<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, T a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <T, U, W> Ops.IntAndObjectToLong<T> indexedMapper(final Ops.ObjectAndObjectToLong<? super T, ? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndObjectToLong<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, T a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> indexedMapper(final Ops.ObjectAndDoubleToObject<? super T, ? extends V> combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndObjectToObject<T, V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, T a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> indexedMapper(final Ops.ObjectAndDoubleToDouble<? super T> combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndObjectToDouble<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, T a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToLong<T> indexedMapper(final Ops.ObjectAndDoubleToLong<? super T> combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndObjectToLong<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, T a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> indexedMapper(final Ops.ObjectAndLongToObject<? super T, ? extends V> combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndObjectToObject<T, V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, T a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> indexedMapper(final Ops.ObjectAndLongToDouble<? super T> combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndObjectToDouble<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, T a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> indexedMapper(final Ops.ObjectAndLongToLong<? super T> combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndObjectToLong<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, T a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static <U, V, W> Ops.IntAndDoubleToObject<V> indexedMapper(final Ops.DoubleAndObjectToObject<? super U, ? extends V> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndDoubleToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, double a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <U, W> Ops.IntAndDoubleToDouble indexedMapper(final Ops.DoubleAndObjectToDouble<? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndDoubleToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, double a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <U, W> Ops.IntAndDoubleToLong indexedMapper(final Ops.DoubleAndObjectToLong<? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndDoubleToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, double a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> indexedMapper(final Ops.DoubleAndDoubleToObject<? extends V> combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndDoubleToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, double a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static Ops.IntAndDoubleToDouble indexedMapper(final Ops.BinaryDoubleOp combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndDoubleToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, double a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static Ops.IntAndDoubleToLong indexedMapper(final Ops.DoubleAndDoubleToLong combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndDoubleToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, double a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> indexedMapper(final Ops.DoubleAndLongToObject<? extends V> combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndDoubleToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, double a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static Ops.IntAndDoubleToDouble indexedMapper(final Ops.DoubleAndLongToDouble combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndDoubleToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, double a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static Ops.IntAndDoubleToLong indexedMapper(final Ops.DoubleAndLongToLong combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndDoubleToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, double a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static <U, V, W> Ops.IntAndLongToObject<V> indexedMapper(final Ops.LongAndObjectToObject<? super U, ? extends V> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndLongToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, long a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <U, W> Ops.IntAndLongToDouble indexedMapper(final Ops.LongAndObjectToDouble<? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndLongToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, long a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <U, W> Ops.IntAndLongToLong indexedMapper(final Ops.LongAndObjectToLong<? super U> combiner, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndLongToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, long a) {
                return combiner.op(a, u.oget(i + this.offset));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> indexedMapper(final Ops.LongAndDoubleToObject<? extends V> combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndLongToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, long a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static Ops.IntAndLongToDouble indexedMapper(final Ops.LongAndDoubleToDouble combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndLongToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, long a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static Ops.IntAndLongToLong indexedMapper(final Ops.LongAndDoubleToLong combiner, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndLongToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, long a) {
                return combiner.op(a, u.dget(i + this.offset));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> indexedMapper(final Ops.LongAndLongToObject<? extends V> combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndLongToObject<V>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public V op(int i, long a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static Ops.IntAndLongToDouble indexedMapper(final Ops.LongAndLongToDouble combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndLongToDouble(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public double op(int i, long a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static Ops.IntAndLongToLong indexedMapper(final Ops.BinaryLongOp combiner, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndLongToLong(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public long op(int i, long a) {
                return combiner.op(a, u.lget(i + this.offset));
            }
        };
    }

    static <T, U, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U, V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U, V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(i, a));
            }
        };
    }

    static <T, U, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.Op<? super U, ? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.ObjectToDouble<? super U> snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToObject<? super T, ? extends U> fst, final Ops.ObjectToLong<? super U> snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U, V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.Op<? super U, ? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.ObjectToDouble<? super U> snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToObject<? extends U> fst, final Ops.ObjectToLong<? super U> snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U, V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.Op<? super U, ? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.ObjectToDouble<? super U> snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <U> Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToObject<? extends U> fst, final Ops.ObjectToLong<? super U> snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.DoubleToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.DoubleOp snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToDouble<? super T> fst, final Ops.DoubleToLong snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.DoubleToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.DoubleOp snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToDouble fst, final Ops.DoubleToLong snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.DoubleToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.DoubleOp snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToDouble fst, final Ops.DoubleToLong snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.LongToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.LongToDouble snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.IntAndObjectToLong<? super T> fst, final Ops.LongOp snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.LongToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.LongToDouble snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.IntAndDoubleToLong fst, final Ops.LongOp snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.LongToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.LongToDouble snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.IntAndLongToLong fst, final Ops.LongOp snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(fst.op(i, a));
            }
        };
    }

    static <T, U, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.Op<? super T, ? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.Op<? super T, ? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T, U> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.Op<? super T, ? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U, V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.DoubleToObject<? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.DoubleToObject<? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U> Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.DoubleToObject<? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U, V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.LongToObject<? extends U> fst, final Ops.IntAndObjectToObject<? super U, ? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U> Ops.IntAndLongToDouble compoundIndexedOp(final Ops.LongToObject<? extends U> fst, final Ops.IntAndObjectToDouble<? super U> snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <U> Ops.IntAndLongToLong compoundIndexedOp(final Ops.LongToObject<? extends U> fst, final Ops.IntAndObjectToLong<? super U> snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.ObjectToDouble<? super T> fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.ObjectToDouble<? super T> fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.ObjectToDouble<? super T> fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.DoubleOp fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.DoubleOp fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.DoubleOp fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.LongToDouble fst, final Ops.IntAndDoubleToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.LongToDouble fst, final Ops.IntAndDoubleToDouble snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.LongToDouble fst, final Ops.IntAndDoubleToLong snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T, V> Ops.IntAndObjectToObject<T, V> compoundIndexedOp(final Ops.ObjectToLong<? super T> fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndObjectToObject<T, V>(){

            @Override
            public V op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T> Ops.IntAndObjectToDouble<T> compoundIndexedOp(final Ops.ObjectToLong<? super T> fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndObjectToDouble<T>(){

            @Override
            public double op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T> Ops.IntAndObjectToLong<T> compoundIndexedOp(final Ops.ObjectToLong<? super T> fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndObjectToLong<T>(){

            @Override
            public long op(int i, T a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <V> Ops.IntAndDoubleToObject<V> compoundIndexedOp(final Ops.DoubleToLong fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndDoubleToObject<V>(){

            @Override
            public V op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndDoubleToDouble compoundIndexedOp(final Ops.DoubleToLong fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndDoubleToDouble(){

            @Override
            public double op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndDoubleToLong compoundIndexedOp(final Ops.DoubleToLong fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndDoubleToLong(){

            @Override
            public long op(int i, double a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <V> Ops.IntAndLongToObject<V> compoundIndexedOp(final Ops.LongOp fst, final Ops.IntAndLongToObject<? extends V> snd) {
        return new Ops.IntAndLongToObject<V>(){

            @Override
            public V op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndLongToDouble compoundIndexedOp(final Ops.LongOp fst, final Ops.IntAndLongToDouble snd) {
        return new Ops.IntAndLongToDouble(){

            @Override
            public double op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static Ops.IntAndLongToLong compoundIndexedOp(final Ops.LongOp fst, final Ops.IntAndLongToLong snd) {
        return new Ops.IntAndLongToLong(){

            @Override
            public long op(int i, long a) {
                return snd.op(i, fst.op(a));
            }
        };
    }

    static <T, U, W> Ops.IntAndObjectPredicate<T> indexedSelector(final Ops.BinaryPredicate<? super T, ? super U> bp, final ParallelArrayWithMapping<W, U> u, final int origin) {
        return new Ops.IntAndObjectPredicate<T>(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public boolean op(int i, T a) {
                int k = i + this.offset;
                return u.isSelected(k) && bp.op(a, u.oget(k));
            }
        };
    }

    static Ops.IntAndDoublePredicate indexedSelector(final Ops.BinaryDoublePredicate bp, final ParallelDoubleArrayWithDoubleMapping u, final int origin) {
        return new Ops.IntAndDoublePredicate(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public boolean op(int i, double a) {
                int k = i + this.offset;
                return u.isSelected(k) && bp.op(a, u.dget(k));
            }
        };
    }

    static Ops.IntAndLongPredicate indexedSelector(final Ops.BinaryLongPredicate bp, final ParallelLongArrayWithLongMapping u, final int origin) {
        return new Ops.IntAndLongPredicate(){
            final int offset;
            {
                this.offset = u.origin - origin;
            }

            @Override
            public boolean op(int i, long a) {
                int k = i + this.offset;
                return u.isSelected(k) && bp.op(a, u.lget(k));
            }
        };
    }

    static <S, T extends S> Ops.IntAndObjectPredicate<T> compoundIndexedSelector(final Ops.Predicate<S> fst, final Ops.IntAndObjectPredicate<? super T> snd) {
        return new Ops.IntAndObjectPredicate<T>(){

            @Override
            public boolean op(int i, T a) {
                return fst.op(a) && snd.op(i, a);
            }
        };
    }

    static <S, T extends S> Ops.IntAndObjectPredicate<T> compoundIndexedSelector(final Ops.IntAndObjectPredicate<S> fst, final Ops.IntAndObjectPredicate<? super T> snd) {
        return new Ops.IntAndObjectPredicate<T>(){

            @Override
            public boolean op(int i, T a) {
                return fst.op(i, a) && snd.op(i, a);
            }
        };
    }

    static <S, T extends S> Ops.IntAndObjectPredicate<T> compoundIndexedSelector(final Ops.IntAndObjectPredicate<S> fst, final Ops.Predicate<? super T> snd) {
        return new Ops.IntAndObjectPredicate<T>(){

            @Override
            public boolean op(int i, T a) {
                return fst.op(i, a) && snd.op(a);
            }
        };
    }

    static Ops.IntAndDoublePredicate compoundIndexedSelector(final Ops.DoublePredicate fst, final Ops.IntAndDoublePredicate snd) {
        return new Ops.IntAndDoublePredicate(){

            @Override
            public boolean op(int i, double a) {
                return fst.op(a) && snd.op(i, a);
            }
        };
    }

    static Ops.IntAndDoublePredicate compoundIndexedSelector(final Ops.IntAndDoublePredicate fst, final Ops.IntAndDoublePredicate snd) {
        return new Ops.IntAndDoublePredicate(){

            @Override
            public boolean op(int i, double a) {
                return fst.op(i, a) && snd.op(i, a);
            }
        };
    }

    static Ops.IntAndDoublePredicate compoundIndexedSelector(final Ops.IntAndDoublePredicate fst, final Ops.DoublePredicate snd) {
        return new Ops.IntAndDoublePredicate(){

            @Override
            public boolean op(int i, double a) {
                return fst.op(i, a) && snd.op(a);
            }
        };
    }

    static Ops.IntAndLongPredicate compoundIndexedSelector(final Ops.LongPredicate fst, final Ops.IntAndLongPredicate snd) {
        return new Ops.IntAndLongPredicate(){

            @Override
            public boolean op(int i, long a) {
                return fst.op(a) && snd.op(i, a);
            }
        };
    }

    static Ops.IntAndLongPredicate compoundIndexedSelector(final Ops.IntAndLongPredicate fst, final Ops.IntAndLongPredicate snd) {
        return new Ops.IntAndLongPredicate(){

            @Override
            public boolean op(int i, long a) {
                return fst.op(i, a) && snd.op(i, a);
            }
        };
    }

    static Ops.IntAndLongPredicate compoundIndexedSelector(final Ops.IntAndLongPredicate fst, final Ops.LongPredicate snd) {
        return new Ops.IntAndLongPredicate(){

            @Override
            public boolean op(int i, long a) {
                return fst.op(i, a) && snd.op(a);
            }
        };
    }

    class FilteredIterator<U>
    implements Iterator<U> {
        Object next;
        int cursor;

        FilteredIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
            this.advance();
        }

        private void advance() {
            while (this.cursor < AbstractParallelAnyArray.this.fence) {
                if (AbstractParallelAnyArray.this.isSelected(this.cursor)) {
                    this.next = AbstractParallelAnyArray.this.oget(this.cursor);
                    break;
                }
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public U next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            Object x = this.next;
            ++this.cursor;
            this.advance();
            return (U)x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class UnfilteredIterator<U>
    implements Iterator<U> {
        int cursor;

        UnfilteredIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public U next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            return (U)AbstractParallelAnyArray.this.oget(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class Sequentially<U>
    implements Iterable<U> {
        Sequentially() {
        }

        @Override
        public Iterator<U> iterator() {
            if (AbstractParallelAnyArray.this.hasFilter()) {
                return new FilteredIterator();
            }
            return new UnfilteredIterator();
        }
    }

    class FilteredAsLongIterator
    implements Iterator<Long> {
        long next;
        int cursor;

        FilteredAsLongIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
            this.advance();
        }

        private void advance() {
            while (this.cursor < AbstractParallelAnyArray.this.fence) {
                if (AbstractParallelAnyArray.this.isSelected(this.cursor)) {
                    this.next = AbstractParallelAnyArray.this.lget(this.cursor);
                    break;
                }
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public Long next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            Long x = this.next;
            ++this.cursor;
            this.advance();
            return x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class UnfilteredAsLongIterator
    implements Iterator<Long> {
        int cursor;

        UnfilteredAsLongIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public Long next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            return AbstractParallelAnyArray.this.lget(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class SequentiallyAsLong
    implements Iterable<Long> {
        SequentiallyAsLong() {
        }

        @Override
        public Iterator<Long> iterator() {
            if (AbstractParallelAnyArray.this.hasFilter()) {
                return new FilteredAsLongIterator();
            }
            return new UnfilteredAsLongIterator();
        }
    }

    class FilteredAsDoubleIterator
    implements Iterator<Double> {
        double next;
        int cursor;

        FilteredAsDoubleIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
            this.advance();
        }

        private void advance() {
            while (this.cursor < AbstractParallelAnyArray.this.fence) {
                if (AbstractParallelAnyArray.this.isSelected(this.cursor)) {
                    this.next = AbstractParallelAnyArray.this.dget(this.cursor);
                    break;
                }
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public Double next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            Double x = this.next;
            ++this.cursor;
            this.advance();
            return x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class UnfilteredAsDoubleIterator
    implements Iterator<Double> {
        int cursor;

        UnfilteredAsDoubleIterator() {
            this.cursor = AbstractParallelAnyArray.this.origin;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < AbstractParallelAnyArray.this.fence;
        }

        @Override
        public Double next() {
            if (this.cursor >= AbstractParallelAnyArray.this.fence) {
                throw new NoSuchElementException();
            }
            return AbstractParallelAnyArray.this.dget(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class SequentiallyAsDouble
    implements Iterable<Double> {
        SequentiallyAsDouble() {
        }

        @Override
        public Iterator<Double> iterator() {
            if (AbstractParallelAnyArray.this.hasFilter()) {
                return new FilteredAsDoubleIterator();
            }
            return new UnfilteredAsDoubleIterator();
        }
    }

    static final class LRLCPap
    extends LLCPap {
        final Ops.IntAndLongPredicate selector;

        LRLCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.IntAndLongToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LROCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.IntAndLongToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DRLCPap
    extends DLCPap {
        final Ops.IntAndDoublePredicate selector;

        DRLCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.IntAndDoubleToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DROCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.IntAndDoubleToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class ORLCPap<T>
    extends OLCPap<T> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        ORLCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.IntAndObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OROCPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Ops.IntAndObjectToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFLCPap
    extends LLCPap {
        final Ops.LongPredicate selector;

        LFLCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.IntAndLongToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LFOCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.LongPredicate s = this.selector;
            Ops.IntAndLongToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFLCPap
    extends DLCPap {
        final Ops.DoublePredicate selector;

        DFLCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.IntAndDoubleToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DFOCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.DoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.DoublePredicate s = this.selector;
            Ops.IntAndDoubleToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFLCPap<T>
    extends OLCPap<T> {
        final Ops.Predicate<? super T> selector;

        OFLCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.IntAndObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OFOCPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.Predicate<T> s = this.selector;
            Ops.IntAndObjectToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LULCPap
    extends LLCPap {
        LULCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToLong op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LUOCPap<U>(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndLongToLong f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.IntAndLongToLong f = this.op;
            long r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class DULCPap
    extends DLCPap {
        DULCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToLong op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DUOCPap<U>(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndDoubleToLong f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.IntAndDoubleToLong f = this.op;
            long r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class OULCPap<T>
    extends OLCPap<T> {
        OULCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OUOCPap<Object, U>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OULCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndObjectToLong f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.IntAndObjectToLong f = this.op;
            long r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static abstract class LLCPap
    extends ParallelLongArrayWithLongMapping {
        final Ops.IntAndLongToLong op;

        LLCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToLong op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            Ops.IntAndLongToLong f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            long[] a = this.array;
            Ops.IntAndLongToLong f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class DLCPap
    extends ParallelDoubleArrayWithLongMapping {
        final Ops.IntAndDoubleToLong op;

        DLCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToLong op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            Ops.IntAndDoubleToLong f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            double[] a = this.array;
            Ops.IntAndDoubleToLong f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class OLCPap<T>
    extends ParallelArrayWithLongMapping<T> {
        final Ops.IntAndObjectToLong<? super T> op;

        OLCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToLong<? super T> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            Ops.IntAndObjectToLong<T> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            Object[] a = this.array;
            Ops.IntAndObjectToLong<T> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static final class LRLMPap
    extends LLMPap {
        final Ops.IntAndLongPredicate selector;

        LRLMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.LongOp op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.LongOp f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.LongOp f = this.op;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DRLMPap
    extends DLMPap {
        final Ops.IntAndDoublePredicate selector;

        DRLMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.DoubleToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.DoubleToLong f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            boolean gotFirst = false;
            long r = base;
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.DoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class ORLMPap<T>
    extends OLMPap<T> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        ORLMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.ObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new ORDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new ORLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OROMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, ORLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.ObjectToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Ops.ObjectToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(i, t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFLMPap
    extends LLMPap {
        final Ops.LongPredicate selector;

        LFLMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.LongOp op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongPredicate s = this.selector;
            Ops.LongOp f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.LongPredicate s = this.selector;
            Ops.LongOp f = this.op;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFLMPap
    extends DLMPap {
        final Ops.DoublePredicate selector;

        DFLMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.DoubleToLong op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.DoublePredicate s = this.selector;
            Ops.DoubleToLong f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            boolean gotFirst = false;
            long r = base;
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            Ops.DoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFLMPap<T>
    extends OLMPap<T> {
        final Ops.Predicate<? super T> selector;

        OFLMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.ObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new OFDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new OFLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OFOMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFLMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.ObjectToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.Predicate<T> s = this.selector;
            Ops.ObjectToLong f = this.op;
            boolean gotFirst = false;
            long r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(t)) continue;
                long y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LULMPap
    extends LLMPap {
        LULMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongOp op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LUOMPap<U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongOp f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.LongOp f = this.op;
            long r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class DULMPap
    extends DLMPap {
        DULMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleToLong op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new DUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new DULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new DUOMPap<U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            double[] a = this.array;
            Ops.DoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.DoubleToLong f = this.op;
            long r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class OULMPap<T>
    extends OLMPap<T> {
        OULMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.ObjectToLong<? super T> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.LongToDouble op) {
            return new OUDMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.LongOp op) {
            return new OULMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.LongToObject<? extends U> op) {
            return new OUOMPap<Object, U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OULMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Object[] a = this.array;
            Ops.ObjectToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.ObjectToLong f = this.op;
            long r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static abstract class LLMPap
    extends ParallelLongArrayWithLongMapping {
        final Ops.LongOp op;

        LLMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongOp op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            long[] a = this.array;
            Ops.LongOp f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            long[] a = this.array;
            Ops.LongOp f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class DLMPap
    extends ParallelDoubleArrayWithLongMapping {
        final Ops.DoubleToLong op;

        DLMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleToLong op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleToLong f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleToLong f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class OLMPap<T>
    extends ParallelArrayWithLongMapping<T> {
        final Ops.ObjectToLong<? super T> op;

        OLMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.ObjectToLong<? super T> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final long lget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.lget(i);
        }

        @Override
        final double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, long[] dest, int offset) {
            Ops.ObjectToLong<T> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
            Object[] a = this.array;
            Ops.ObjectToLong<T> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static final class LRDCPap
    extends LDCPap {
        final Ops.IntAndLongPredicate selector;

        LRDCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.IntAndLongToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LROCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.IntAndLongToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DRDCPap
    extends DDCPap {
        final Ops.IntAndDoublePredicate selector;

        DRDCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.IntAndDoubleToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DROCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.IntAndDoubleToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class ORDCPap<T>
    extends ODCPap<T> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        ORDCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.IntAndObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OROCPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Ops.IntAndObjectToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFDCPap
    extends LDCPap {
        final Ops.LongPredicate selector;

        LFDCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.IntAndLongToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LFOCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.LongPredicate s = this.selector;
            Ops.IntAndLongToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFDCPap
    extends DDCPap {
        final Ops.DoublePredicate selector;

        DFDCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.IntAndDoubleToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DFOCPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.DoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.DoublePredicate s = this.selector;
            Ops.IntAndDoubleToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFDCPap<T>
    extends ODCPap<T> {
        final Ops.Predicate<? super T> selector;

        OFDCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.IntAndObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OFOCPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.Predicate<T> s = this.selector;
            Ops.IntAndObjectToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(i, t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LUDCPap
    extends LDCPap {
        LUDCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToDouble op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LUOCPap<U>(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndLongToDouble f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.IntAndLongToDouble f = this.op;
            double r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class DUDCPap
    extends DDCPap {
        DUDCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToDouble op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DUOCPap<U>(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndDoubleToDouble f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.IntAndDoubleToDouble f = this.op;
            double r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class OUDCPap<T>
    extends ODCPap<T> {
        OUDCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OUOCPap<Object, U>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndObjectToDouble f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.IntAndObjectToDouble f = this.op;
            double r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static abstract class LDCPap
    extends ParallelLongArrayWithDoubleMapping {
        final Ops.IntAndLongToDouble op;

        LDCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToDouble op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            Ops.IntAndLongToDouble f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            long[] a = this.array;
            Ops.IntAndLongToDouble f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class DDCPap
    extends ParallelDoubleArrayWithDoubleMapping {
        final Ops.IntAndDoubleToDouble op;

        DDCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToDouble op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            Ops.IntAndDoubleToDouble f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            double[] a = this.array;
            Ops.IntAndDoubleToDouble f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class ODCPap<T>
    extends ParallelArrayWithDoubleMapping<T> {
        final Ops.IntAndObjectToDouble<? super T> op;

        ODCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToDouble<? super T> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            Ops.IntAndObjectToDouble<T> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            Object[] a = this.array;
            Ops.IntAndObjectToDouble<T> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static final class LRDMPap
    extends LDMPap {
        final Ops.IntAndLongPredicate selector;

        LRDMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.LongToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            Ops.LongToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.LongToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DRDMPap
    extends DDMPap {
        final Ops.IntAndDoublePredicate selector;

        DRDMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.DoubleOp op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DRDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.DoubleOp f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndDoublePredicate s = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class ORDMPap<T>
    extends ODMPap<T> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        ORDMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.ObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new ORDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new ORLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OROMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, ORDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, ORDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.ObjectToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Ops.ObjectToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(i, t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFDMPap
    extends LDMPap {
        final Ops.LongPredicate selector;

        LFDMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.LongToDouble op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            Ops.LongToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.LongPredicate s = this.selector;
            Ops.LongToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFDMPap
    extends DDMPap {
        final Ops.DoublePredicate selector;

        DFDMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.DoubleOp op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.DoublePredicate s = this.selector;
            Ops.DoubleOp f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.DoublePredicate s = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            for (int i = lo; i < hi; ++i) {
                double t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFDMPap<T>
    extends ODMPap<T> {
        final Ops.Predicate<? super T> selector;

        OFDMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.ObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new OFDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new OFLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OFOMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.ObjectToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.Predicate<T> s = this.selector;
            Ops.ObjectToDouble f = this.op;
            boolean gotFirst = false;
            double r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object t = a[i];
                if (!s.op(t)) continue;
                double y = f.op(t);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LUDMPap
    extends LDMPap {
        LUDMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongToDouble op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new LULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new LUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new LUOMPap<U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.LongToDouble f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.LongToDouble f = this.op;
            double r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class DUDMPap
    extends DDMPap {
        DUDMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleOp op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DUOMPap<U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            double r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class OUDMPap<T>
    extends ODMPap<T> {
        OUDMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.ObjectToDouble<? super T> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.DoubleOp op) {
            return new OUDMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.DoubleToLong op) {
            return new OULMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new OUOMPap<Object, U>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUDMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.ObjectToDouble f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.ObjectToDouble f = this.op;
            double r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static abstract class LDMPap
    extends ParallelLongArrayWithDoubleMapping {
        final Ops.LongToDouble op;

        LDMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongToDouble op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            long[] a = this.array;
            Ops.LongToDouble f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            long[] a = this.array;
            Ops.LongToDouble f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class DDMPap
    extends ParallelDoubleArrayWithDoubleMapping {
        final Ops.DoubleOp op;

        DDMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleOp op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleOp f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class ODMPap<T>
    extends ParallelArrayWithDoubleMapping<T> {
        final Ops.ObjectToDouble<? super T> op;

        ODMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.ObjectToDouble<? super T> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final double dget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final Object oget(int i) {
            return this.dget(i);
        }

        @Override
        final long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafTransfer(int lo, int hi, double[] dest, int offset) {
            Ops.ObjectToDouble<T> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
            Object[] a = this.array;
            Ops.ObjectToDouble<T> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static final class LROCPap<U>
    extends LOCPap<U> {
        final Ops.IntAndLongPredicate selector;

        LROCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.IntAndLongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DROCPap<U>
    extends DOCPap<U> {
        final Ops.IntAndDoublePredicate selector;

        DROCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.IntAndDoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndDoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OROCPap<T, U>
    extends OOCPap<T, U> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        OROCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.IntAndObjectToObject<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFOCPap<U>
    extends LOCPap<U> {
        final Ops.LongPredicate selector;

        LFOCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.IntAndLongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            Ops.IntAndLongToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFOCPap<U>
    extends DOCPap<U> {
        final Ops.DoublePredicate selector;

        DFOCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.IntAndDoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.DoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.DoublePredicate s = this.selector;
            double[] a = this.array;
            Ops.IntAndDoubleToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFOCPap<T, U>
    extends OOCPap<T, U> {
        final Ops.Predicate<? super T> selector;

        OFOCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.IntAndObjectToObject<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(i, x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.IntAndObjectToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(i, x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LUOCPap<U>
    extends LOCPap<U> {
        LUOCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndLongToObject f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.IntAndLongToObject f = this.op;
            Object r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class DUOCPap<U>
    extends DOCPap<U> {
        DUOCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndDoubleToObject f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.IntAndDoubleToObject f = this.op;
            Object r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static final class OUOCPap<T, U>
    extends OOCPap<T, U> {
        OUOCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToObject<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOCPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndObjectToObject f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(i, a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.IntAndObjectToObject f = this.op;
            Object r = f.op(lo, a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(i, a[i]));
            }
            return r;
        }
    }

    static abstract class LOCPap<U>
    extends ParallelLongArrayWithMapping<U> {
        final Ops.IntAndLongToObject<? extends U> op;

        LOCPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongToObject<? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            Ops.IntAndLongToObject<U> f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            long[] a = this.array;
            Ops.IntAndLongToObject<U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class DOCPap<U>
    extends ParallelDoubleArrayWithMapping<U> {
        final Ops.IntAndDoubleToObject<? extends U> op;

        DOCPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoubleToObject<? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            Ops.IntAndDoubleToObject<U> f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            double[] a = this.array;
            Ops.IntAndDoubleToObject<U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static abstract class OOCPap<T, U>
    extends ParallelArrayWithMapping<T, U> {
        final Ops.IntAndObjectToObject<? super T, ? extends U> op;

        OOCPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectToObject<? super T, ? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(i, this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            Ops.IntAndObjectToObject<T, U> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(i, a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            Object[] a = this.array;
            Ops.IntAndObjectToObject<T, U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                int idx = indices[i];
                dest[offset++] = f.op(idx, a[idx]);
            }
        }
    }

    static final class LROMPap<U>
    extends LOMPap<U> {
        final Ops.IntAndLongPredicate selector;

        LROMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector, Ops.LongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LROMPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.LongToObject f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndLongPredicate s = this.selector;
            Ops.LongToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DROMPap<U>
    extends DOMPap<U> {
        final Ops.IntAndDoublePredicate selector;

        DROMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector, Ops.DoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            PAS.FJOSelectAllDriver r = new PAS.FJOSelectAllDriver((AbstractParallelAnyArray)this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DROMPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.DoubleToObject f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            boolean gotFirst = false;
            Object r = base;
            Ops.IntAndDoublePredicate s = this.selector;
            Ops.DoubleToObject f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OROMPap<T, U>
    extends OOMPap<T, U> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        OROMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector, Ops.Op<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OROMPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new ORDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new ORLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OROMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.Op f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.Op f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LFOMPap<U>
    extends LOMPap<U> {
        final Ops.LongPredicate selector;

        LFOMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector, Ops.LongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LFOMPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, LFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, LFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.LongPredicate s = this.selector;
            Ops.LongToObject f = this.op;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.LongPredicate s = this.selector;
            Ops.LongToObject f = this.op;
            boolean gotFirst = false;
            Object r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class DFOMPap<U>
    extends DOMPap<U> {
        final Ops.DoublePredicate selector;

        DFOMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector, Ops.DoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArray<U> all(Class<? super U> elementType) {
            PAS.FJOSelectAllDriver r = new PAS.FJOSelectAllDriver((AbstractParallelAnyArray)this, elementType);
            this.ex.invoke(r);
            return new ParallelArray<Object>(this.ex, r.results);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DFOMPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, DFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, DFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.DoublePredicate s = this.selector;
            Ops.DoubleToObject f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            boolean gotFirst = false;
            Object r = base;
            Ops.DoublePredicate s = this.selector;
            Ops.DoubleToObject f = this.op;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class OFOMPap<T, U>
    extends OOMPap<T, U> {
        final Ops.Predicate<? super T> selector;

        OFOMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector, Ops.Op<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OFOMPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new OFDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new OFLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, OFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, OFOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.Op f = this.op;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(f.op(x));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            Ops.Op f = this.op;
            boolean gotFirst = false;
            Object r = base;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                Object y = f.op(x);
                if (!gotFirst) {
                    gotFirst = true;
                    r = y;
                    continue;
                }
                r = reducer.op(r, y);
            }
            return r;
        }
    }

    static final class LUOMPap<U>
    extends LOMPap<U> {
        LUOMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new LUOMPap<V>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new LULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new LUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, LUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, LUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, LUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            long[] a = this.array;
            Ops.LongToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            Ops.LongToObject f = this.op;
            Object r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class DUOMPap<U>
    extends DOMPap<U> {
        DUOMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleToObject<? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new DUOMPap<V>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.ObjectToDouble<? super U> op) {
            return new DUDMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.ObjectToLong<? super U> op) {
            return new DULMPap(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, DUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, DUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, DUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            double[] a = this.array;
            Ops.DoubleToObject f = this.op;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            Ops.DoubleToObject f = this.op;
            Object r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static final class OUOMPap<T, U>
    extends OOMPap<T, U> {
        OUOMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Op<? super T, ? extends U> op) {
            super(ex, origin, fence, array, op);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withMapping(Ops.Op<? super U, ? extends V> op) {
            return new OUOMPap<Object, V>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super U> op) {
            return new OUDMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super U> op) {
            return new OULMPap<Object>(this.ex, this.origin, this.fence, this.array, CommonOps.compoundOp(this.op, op));
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super U, ? extends V> mapper) {
            return new OUOCPap<Object, V>(this.ex, this.origin, this.fence, this.array, OUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super U> mapper) {
            return new OUDCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super U> mapper) {
            return new OULCPap<Object>(this.ex, this.origin, this.fence, this.array, OUOMPap.compoundIndexedOp(this.op, mapper));
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Op f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(f.op(a[i]));
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Ops.Op f = this.op;
            Object r = f.op(a[lo]);
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, f.op(a[i]));
            }
            return r;
        }
    }

    static abstract class LOMPap<U>
    extends ParallelLongArrayWithMapping<U> {
        final Ops.LongToObject<? extends U> op;

        LOMPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongToObject<? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            long[] a = this.array;
            Ops.LongToObject<U> f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            long[] a = this.array;
            Ops.LongToObject<U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class DOMPap<U>
    extends ParallelDoubleArrayWithMapping<U> {
        final Ops.DoubleToObject<? extends U> op;

        DOMPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoubleToObject<? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleToObject<U> f = this.op;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            double[] a = this.array;
            Ops.DoubleToObject<U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static abstract class OOMPap<T, U>
    extends ParallelArrayWithMapping<T, U> {
        final Ops.Op<? super T, ? extends U> op;

        OOMPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Op<? super T, ? extends U> op) {
            super(ex, origin, fence, array);
            this.op = op;
        }

        @Override
        final boolean hasMap() {
            return true;
        }

        @Override
        final Object oget(int i) {
            return this.op.op(this.array[i]);
        }

        @Override
        final double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        final long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafTransfer(int lo, int hi, Object[] dest, int offset) {
            Ops.Op<T, U> f = this.op;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                dest[offset++] = f.op(a[i]);
            }
        }

        @Override
        final void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
            Object[] a = this.array;
            Ops.Op<T, U> f = this.op;
            for (int i = loIdx; i < hiIdx; ++i) {
                dest[offset++] = f.op(a[indices[i]]);
            }
        }
    }

    static final class LRPap
    extends ParallelLongArrayWithFilter {
        final Ops.IntAndLongPredicate selector;

        LRPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.IntAndLongPredicate selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelLongArrayWithFilter withFilter(Ops.LongPredicate selector) {
            return new LRPap(this.ex, this.origin, this.fence, this.array, LRPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public ParallelLongArrayWithFilter withIndexedFilter(Ops.IntAndLongPredicate selector) {
            return new LRPap(this.ex, this.origin, this.fence, this.array, LRPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        final void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.IntAndLongPredicate s = this.selector;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(x);
            }
        }

        @Override
        final long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.IntAndLongPredicate s = this.selector;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.LongOp op) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToLong op) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndLongToLong op) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.LongGenerator generator) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, long value) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, long[] other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (s.op(i, x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelLongArrayWithLongMapping other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            Ops.IntAndLongPredicate s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(i, x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.lget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, other.lget(k));
                    }
                    ++k;
                }
            } else {
                long[] b = other.array;
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static final class DRPap
    extends ParallelDoubleArrayWithFilter {
        final Ops.IntAndDoublePredicate selector;

        DRPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.IntAndDoublePredicate selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithFilter withFilter(Ops.DoublePredicate selector) {
            return new DRPap(this.ex, this.origin, this.fence, this.array, DRPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public ParallelDoubleArrayWithFilter withIndexedFilter(Ops.IntAndDoublePredicate selector) {
            return new DRPap(this.ex, this.origin, this.fence, this.array, DRPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DROMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DRDMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DRLMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DROCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DRDCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DRLCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        final void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.IntAndDoublePredicate s = this.selector;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(x);
            }
        }

        @Override
        final double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.IntAndDoublePredicate s = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.DoubleOp op) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToDouble op) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndDoubleToDouble op) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.DoubleGenerator generator) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, double value) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, double[] other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (s.op(i, x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelDoubleArrayWithDoubleMapping other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            Ops.IntAndDoublePredicate s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(i, x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.dget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, other.dget(k));
                    }
                    ++k;
                }
            } else {
                double[] b = other.array;
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static final class ORPap<T>
    extends ParallelArrayWithFilter<T> {
        final Ops.IntAndObjectPredicate<? super T> selector;

        ORPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.IntAndObjectPredicate<? super T> selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(i, this.array[i]);
        }

        @Override
        public ParallelArrayWithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
            return new ORPap<T>(this.ex, this.origin, this.fence, this.array, ORPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public ParallelArrayWithFilter<T> withIndexedFilter(Ops.IntAndObjectPredicate<? super T> selector) {
            return new ORPap<T>(this.ex, this.origin, this.fence, this.array, ORPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.Op<? super T, ? extends U> op) {
            return new OROMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super T> op) {
            return new ORDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super T> op) {
            return new ORLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super T, ? extends V> mapper) {
            return new OROCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super T> mapper) {
            return new ORDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super T> mapper) {
            return new ORLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                procedure.op(x);
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.IntAndObjectPredicate<T> s = this.selector;
            boolean gotFirst = false;
            Object r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.Op op) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToObject op) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndObjectToObject op) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(i, x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.Generator generator) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, Object value) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(i, a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, Object[] other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (s.op(i, x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelArrayWithMapping other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            Ops.IntAndObjectPredicate<T> s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(i, x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.oget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, other.oget(k));
                    }
                    ++k;
                }
            } else {
                Object[] b = other.array;
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(i, x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static final class LFPap
    extends ParallelLongArrayWithFilter {
        final Ops.LongPredicate selector;

        LFPap(ForkJoinExecutor ex, int origin, int fence, long[] array, Ops.LongPredicate selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelLongArrayWithFilter withFilter(Ops.LongPredicate selector) {
            return new LFPap(this.ex, this.origin, this.fence, this.array, CommonOps.andPredicate(this.selector, selector));
        }

        @Override
        public ParallelLongArrayWithFilter withIndexedFilter(Ops.IntAndLongPredicate selector) {
            return new LRPap(this.ex, this.origin, this.fence, this.array, LFPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        final void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            Ops.LongPredicate s = this.selector;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                procedure.op(x);
            }
        }

        @Override
        final long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            Ops.LongPredicate s = this.selector;
            boolean gotFirst = false;
            long r = base;
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.LongOp op) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToLong op) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndLongToLong op) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.LongGenerator generator) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, long value) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, long[] other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                long x = a[i];
                if (s.op(x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelLongArrayWithLongMapping other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            Ops.LongPredicate s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.lget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, other.lget(k));
                    }
                    ++k;
                }
            } else {
                long[] b = other.array;
                for (int i = l; i < h; ++i) {
                    long x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static final class DFPap
    extends ParallelDoubleArrayWithFilter {
        final Ops.DoublePredicate selector;

        DFPap(ForkJoinExecutor ex, int origin, int fence, double[] array, Ops.DoublePredicate selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelDoubleArrayWithFilter withFilter(Ops.DoublePredicate selector) {
            return new DFPap(this.ex, this.origin, this.fence, this.array, CommonOps.andPredicate(this.selector, selector));
        }

        @Override
        public ParallelDoubleArrayWithFilter withIndexedFilter(Ops.IntAndDoublePredicate selector) {
            return new DRPap(this.ex, this.origin, this.fence, this.array, DFPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DFOMPap<U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DFDMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DFLMPap(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DFOCPap<V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DFDCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DFLCPap(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        final void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            Ops.DoublePredicate s = this.selector;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                procedure.op(x);
            }
        }

        @Override
        final double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            Ops.DoublePredicate s = this.selector;
            boolean gotFirst = false;
            double r = base;
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.DoubleOp op) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToDouble op) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndDoubleToDouble op) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.DoubleGenerator generator) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, double value) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, double[] other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                double x = a[i];
                if (s.op(x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelDoubleArrayWithDoubleMapping other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            Ops.DoublePredicate s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.dget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, other.dget(k));
                    }
                    ++k;
                }
            } else {
                double[] b = other.array;
                for (int i = l; i < h; ++i) {
                    double x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static final class OFPap<T>
    extends ParallelArrayWithFilter<T> {
        final Ops.Predicate<? super T> selector;

        OFPap(ForkJoinExecutor ex, int origin, int fence, T[] array, Ops.Predicate<? super T> selector) {
            super(ex, origin, fence, array);
            this.selector = selector;
        }

        @Override
        boolean hasFilter() {
            return true;
        }

        @Override
        boolean isSelected(int i) {
            return this.selector.op(this.array[i]);
        }

        @Override
        public ParallelArrayWithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
            return new OFPap<T>(this.ex, this.origin, this.fence, this.array, CommonOps.andPredicate(this.selector, selector));
        }

        @Override
        public ParallelArrayWithFilter<T> withIndexedFilter(Ops.IntAndObjectPredicate<? super T> selector) {
            return new ORPap<T>(this.ex, this.origin, this.fence, this.array, OFPap.compoundIndexedSelector(this.selector, selector));
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.Op<? super T, ? extends U> op) {
            return new OFOMPap<T, U>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super T> op) {
            return new OFDMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super T> op) {
            return new OFLMPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, op);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super T, ? extends V> mapper) {
            return new OFOCPap<T, V>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super T> mapper) {
            return new OFDCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super T> mapper) {
            return new OFLCPap<T>(this.ex, this.origin, this.fence, this.array, this.selector, mapper);
        }

        @Override
        void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Ops.Predicate<T> s = this.selector;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                procedure.op(x);
            }
        }

        @Override
        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            Ops.Predicate<T> s = this.selector;
            boolean gotFirst = false;
            Object r = base;
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                if (!gotFirst) {
                    gotFirst = true;
                    r = x;
                    continue;
                }
                r = reducer.op(r, x);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.Op op) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(x);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToObject op) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndObjectToObject op) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (!s.op(x)) continue;
                a[i] = op.op(i, x);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.Generator generator) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, Object value) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            for (int i = l; i < h; ++i) {
                if (!s.op(a[i])) continue;
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, Object[] other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                Object x = a[i];
                if (s.op(x)) {
                    a[i] = combiner.op(x, other[k]);
                }
                ++k;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelArrayWithMapping other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            Ops.Predicate<T> s = this.selector;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(x) && other.isSelected(k)) {
                        a[i] = combiner.op(x, other.oget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, other.oget(k));
                    }
                    ++k;
                }
            } else {
                Object[] b = other.array;
                for (int i = l; i < h; ++i) {
                    Object x = a[i];
                    if (s.op(x)) {
                        a[i] = combiner.op(x, b[k]);
                    }
                    ++k;
                }
            }
        }
    }

    static class LUPap
    extends ParallelLongArrayWithBounds {
        LUPap(ForkJoinExecutor ex, int origin, int fence, long[] array) {
            super(ex, origin, fence, array);
        }

        @Override
        public ParallelLongArrayWithBounds withBounds(int lo, int hi) {
            this.boundsCheck(lo, hi);
            return new LUPap(this.ex, this.origin + lo, this.origin + hi, this.array);
        }

        @Override
        public ParallelLongArrayWithFilter withFilter(Ops.LongPredicate selector) {
            return new LFPap(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public ParallelLongArrayWithFilter withIndexedFilter(Ops.IntAndLongPredicate selector) {
            return new LRPap(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public <U> ParallelLongArrayWithMapping<U> withMapping(Ops.LongToObject<? extends U> op) {
            return new LUOMPap<U>(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelLongArrayWithLongMapping withMapping(Ops.LongOp op) {
            return new LULMPap(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withMapping(Ops.LongToDouble op) {
            return new LUDMPap(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public <V> ParallelLongArrayWithMapping<V> withIndexedMapping(Ops.IntAndLongToObject<? extends V> mapper) {
            return new LUOCPap<V>(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelLongArrayWithDoubleMapping withIndexedMapping(Ops.IntAndLongToDouble mapper) {
            return new LUDCPap(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelLongArrayWithLongMapping withIndexedMapping(Ops.IntAndLongToLong mapper) {
            return new LULCPap(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public int indexOf(long target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJLIndexOf f = new PAS.FJLIndexOf(this, this.origin, this.fence, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public int binarySearch(long target) {
            long[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                long m = a[mid];
                if (target == m) {
                    return mid;
                }
                if (target < m) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int binarySearch(long target, Ops.LongComparator comparator) {
            long[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = comparator.compare(target, a[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public ParallelLongArrayWithBounds cumulate(Ops.LongReducer reducer, long base) {
            PAS.FJLCumulateOp op = new PAS.FJLCumulateOp(this, reducer, base);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return this;
        }

        @Override
        public ParallelLongArrayWithBounds cumulateSum() {
            PAS.FJLCumulatePlusOp op = new PAS.FJLCumulatePlusOp(this);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return this;
        }

        @Override
        public long precumulate(Ops.LongReducer reducer, long base) {
            PAS.FJLPrecumulateOp op = new PAS.FJLPrecumulateOp(this, reducer, base);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return r.out;
        }

        @Override
        public long precumulateSum() {
            PAS.FJLPrecumulatePlusOp op = new PAS.FJLPrecumulatePlusOp(this);
            PAS.FJLScan r = new PAS.FJLScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return r.out;
        }

        @Override
        public ParallelLongArrayWithBounds sort(Ops.LongComparator cmp) {
            this.ex.invoke(new PAS.FJLSorter(cmp, this.array, new long[this.fence], this.origin, this.fence - this.origin, this.getThreshold()));
            return this;
        }

        @Override
        public ParallelLongArrayWithBounds sort() {
            this.ex.invoke(new PAS.FJLCSorter(this.array, new long[this.fence], this.origin, this.fence - this.origin, this.getThreshold()));
            return this;
        }

        @Override
        final void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
            long[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(a[i]);
            }
        }

        @Override
        final long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            if (lo >= hi) {
                return base;
            }
            long[] a = this.array;
            long r = a[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, a[i]);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.LongOp op) {
            long[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(a[i]);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToLong op) {
            long[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndLongToLong op) {
            long[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i, a[i]);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.LongGenerator generator) {
            long[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, long value) {
            long[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, long[] other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                a[i] = combiner.op(a[i], other[k++]);
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelLongArrayWithLongMapping other, int otherOffset, Ops.BinaryLongOp combiner) {
            long[] a = this.array;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    if (other.isSelected(k)) {
                        a[i] = combiner.op(a[i], other.lget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], other.lget(k++));
                }
            } else {
                long[] b = other.array;
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], b[k++]);
                }
            }
        }
    }

    static class DUPap
    extends ParallelDoubleArrayWithBounds {
        DUPap(ForkJoinExecutor ex, int origin, int fence, double[] array) {
            super(ex, origin, fence, array);
        }

        @Override
        public ParallelDoubleArrayWithBounds withBounds(int lo, int hi) {
            this.boundsCheck(lo, hi);
            return new DUPap(this.ex, this.origin + lo, this.origin + hi, this.array);
        }

        @Override
        public ParallelDoubleArrayWithFilter withFilter(Ops.DoublePredicate selector) {
            return new DFPap(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public ParallelDoubleArrayWithFilter withIndexedFilter(Ops.IntAndDoublePredicate selector) {
            return new DRPap(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public <U> ParallelDoubleArrayWithMapping<U> withMapping(Ops.DoubleToObject<? extends U> op) {
            return new DUOMPap<U>(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withMapping(Ops.DoubleOp op) {
            return new DUDMPap(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withMapping(Ops.DoubleToLong op) {
            return new DULMPap(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public <V> ParallelDoubleArrayWithMapping<V> withIndexedMapping(Ops.IntAndDoubleToObject<? extends V> mapper) {
            return new DUOCPap<V>(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelDoubleArrayWithDoubleMapping withIndexedMapping(Ops.IntAndDoubleToDouble mapper) {
            return new DUDCPap(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelDoubleArrayWithLongMapping withIndexedMapping(Ops.IntAndDoubleToLong mapper) {
            return new DULCPap(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public int indexOf(double target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJDIndexOf f = new PAS.FJDIndexOf(this, this.origin, this.fence, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public int binarySearch(double target) {
            double[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                double m = a[mid];
                if (target == m) {
                    return mid;
                }
                if (target < m) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int binarySearch(double target, Ops.DoubleComparator comparator) {
            double[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = comparator.compare(target, a[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public ParallelDoubleArrayWithBounds cumulate(Ops.DoubleReducer reducer, double base) {
            PAS.FJDCumulateOp op = new PAS.FJDCumulateOp(this, reducer, base);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return this;
        }

        @Override
        public ParallelDoubleArrayWithBounds cumulateSum() {
            PAS.FJDCumulatePlusOp op = new PAS.FJDCumulatePlusOp(this);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return this;
        }

        @Override
        public double precumulate(Ops.DoubleReducer reducer, double base) {
            PAS.FJDPrecumulateOp op = new PAS.FJDPrecumulateOp(this, reducer, base);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return r.out;
        }

        @Override
        public double precumulateSum() {
            PAS.FJDPrecumulatePlusOp op = new PAS.FJDPrecumulatePlusOp(this);
            PAS.FJDScan r = new PAS.FJDScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return r.out;
        }

        @Override
        public ParallelDoubleArrayWithBounds sort(Ops.DoubleComparator cmp) {
            this.ex.invoke(new PAS.FJDSorter(cmp, this.array, new double[this.fence], this.origin, this.fence - this.origin, this.getThreshold()));
            return this;
        }

        @Override
        public ParallelDoubleArrayWithBounds sort() {
            this.ex.invoke(new PAS.FJDCSorter(this.array, new double[this.fence], this.origin, this.fence - this.origin, this.getThreshold()));
            return this;
        }

        @Override
        final void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
            double[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(a[i]);
            }
        }

        @Override
        final double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            if (lo >= hi) {
                return base;
            }
            double[] a = this.array;
            double r = a[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, a[i]);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.DoubleOp op) {
            double[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(a[i]);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToDouble op) {
            double[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndDoubleToDouble op) {
            double[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i, a[i]);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.DoubleGenerator generator) {
            double[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, double value) {
            double[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, double[] other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                a[i] = combiner.op(a[i], other[k++]);
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelDoubleArrayWithDoubleMapping other, int otherOffset, Ops.BinaryDoubleOp combiner) {
            double[] a = this.array;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    if (other.isSelected(k)) {
                        a[i] = combiner.op(a[i], other.dget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], other.dget(k++));
                }
            } else {
                double[] b = other.array;
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], b[k++]);
                }
            }
        }
    }

    static class OUPap<T>
    extends ParallelArrayWithBounds<T> {
        OUPap(ForkJoinExecutor ex, int origin, int fence, T[] array) {
            super(ex, origin, fence, array);
        }

        @Override
        public ParallelArrayWithBounds<T> withBounds(int lo, int hi) {
            this.boundsCheck(lo, hi);
            return new OUPap<Object>(this.ex, this.origin + lo, this.origin + hi, this.array);
        }

        @Override
        public ParallelArrayWithFilter<T> withFilter(Ops.Predicate<? super T> selector) {
            return new OFPap<T>(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public ParallelArrayWithFilter<T> withIndexedFilter(Ops.IntAndObjectPredicate<? super T> selector) {
            return new ORPap<T>(this.ex, this.origin, this.fence, this.array, selector);
        }

        @Override
        public <U> ParallelArrayWithMapping<T, U> withMapping(Ops.Op<? super T, ? extends U> op) {
            return new OUOMPap<T, U>(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withMapping(Ops.ObjectToDouble<? super T> op) {
            return new OUDMPap<T>(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withMapping(Ops.ObjectToLong<? super T> op) {
            return new OULMPap<T>(this.ex, this.origin, this.fence, this.array, op);
        }

        @Override
        public <V> ParallelArrayWithMapping<T, V> withIndexedMapping(Ops.IntAndObjectToObject<? super T, ? extends V> mapper) {
            return new OUOCPap<T, V>(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelArrayWithDoubleMapping<T> withIndexedMapping(Ops.IntAndObjectToDouble<? super T> mapper) {
            return new OUDCPap<T>(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public ParallelArrayWithLongMapping<T> withIndexedMapping(Ops.IntAndObjectToLong<? super T> mapper) {
            return new OULCPap<T>(this.ex, this.origin, this.fence, this.array, mapper);
        }

        @Override
        public int indexOf(T target) {
            AtomicInteger result = new AtomicInteger(-1);
            PAS.FJOIndexOf f = new PAS.FJOIndexOf(this, this.origin, this.fence, null, result, target);
            this.ex.invoke(f);
            return result.get();
        }

        @Override
        public int binarySearch(T target) {
            Object[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = ((Comparable)target).compareTo((Comparable)a[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public int binarySearch(T target, Comparator<? super T> comparator) {
            Comparator<Object> cmp = comparator;
            Object[] a = this.array;
            int lo = this.origin;
            int hi = this.fence - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int c = cmp.compare(target, a[mid]);
                if (c == 0) {
                    return mid;
                }
                if (c < 0) {
                    hi = mid - 1;
                    continue;
                }
                lo = mid + 1;
            }
            return -1;
        }

        @Override
        public ParallelArrayWithBounds<T> cumulate(Ops.Reducer<T> reducer, T base) {
            PAS.FJOCumulateOp op = new PAS.FJOCumulateOp(this, reducer, base);
            PAS.FJOScan r = new PAS.FJOScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return this;
        }

        @Override
        public T precumulate(Ops.Reducer<T> reducer, T base) {
            PAS.FJOPrecumulateOp op = new PAS.FJOPrecumulateOp(this, reducer, base);
            PAS.FJOScan r = new PAS.FJOScan(null, op, this.origin, this.fence);
            this.ex.invoke(r);
            return (T)r.out;
        }

        @Override
        public ParallelArrayWithBounds<T> sort(Comparator<? super T> cmp) {
            Object[] a = this.array;
            Class<?> tc = this.array.getClass().getComponentType();
            Object[] ws = (Object[])Array.newInstance(tc, this.fence);
            this.ex.invoke(new PAS.FJOSorter(cmp, this.array, ws, this.origin, this.fence - this.origin, this.getThreshold()));
            return this;
        }

        @Override
        public ParallelArrayWithBounds<T> sort() {
            Object[] a = this.array;
            Class<?> tc = this.array.getClass().getComponentType();
            if (!Comparable.class.isAssignableFrom(tc)) {
                this.sort(CommonOps.castedComparator());
            } else {
                Comparable[] ca = (Comparable[])this.array;
                Comparable[] ws = (Comparable[])Array.newInstance(tc, this.fence);
                this.ex.invoke(new PAS.FJOCSorter(ca, ws, this.origin, this.fence - this.origin, this.getThreshold()));
            }
            return this;
        }

        @Override
        final void leafApply(int lo, int hi, Ops.Procedure procedure) {
            Object[] a = this.array;
            for (int i = lo; i < hi; ++i) {
                procedure.op(a[i]);
            }
        }

        @Override
        final Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            if (lo >= hi) {
                return base;
            }
            Object[] a = this.array;
            Object r = a[lo];
            for (int i = lo + 1; i < hi; ++i) {
                r = reducer.op(r, a[i]);
            }
            return r;
        }

        @Override
        final void leafTransform(int l, int h, Ops.Op op) {
            Object[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(a[i]);
            }
        }

        @Override
        final void leafIndexMap(int l, int h, Ops.IntToObject op) {
            Object[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i);
            }
        }

        @Override
        final void leafBinaryIndexMap(int l, int h, Ops.IntAndObjectToObject op) {
            Object[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = op.op(i, a[i]);
            }
        }

        @Override
        final void leafGenerate(int l, int h, Ops.Generator generator) {
            Object[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = generator.op();
            }
        }

        @Override
        final void leafFill(int l, int h, Object value) {
            Object[] a = this.array;
            for (int i = l; i < h; ++i) {
                a[i] = value;
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, Object[] other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            int k = l + otherOffset;
            for (int i = l; i < h; ++i) {
                a[i] = combiner.op(a[i], other[k++]);
            }
        }

        @Override
        final void leafCombineInPlace(int l, int h, ParallelArrayWithMapping other, int otherOffset, Ops.BinaryOp combiner) {
            Object[] a = this.array;
            int k = l + otherOffset;
            if (other.hasFilter()) {
                for (int i = l; i < h; ++i) {
                    if (other.isSelected(k)) {
                        a[i] = combiner.op(a[i], other.oget(k));
                    }
                    ++k;
                }
            } else if (other.hasMap()) {
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], other.oget(k++));
                }
            } else {
                Object[] b = other.array;
                for (int i = l; i < h; ++i) {
                    a[i] = combiner.op(a[i], b[k++]);
                }
            }
        }
    }

    static abstract class LPap
    extends AbstractParallelAnyArray {
        long[] array;

        LPap(ForkJoinExecutor ex, int origin, int fence, long[] array) {
            super(ex, origin, fence);
            this.array = array;
        }

        @Override
        final long[] lgetArray() {
            return this.array;
        }

        @Override
        Object oget(int i) {
            return this.lget(i);
        }

        @Override
        double dget(int i) {
            return this.lget(i);
        }

        @Override
        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            long[] array = this.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }

        @Override
        final int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            long[] array = this.array;
            for (int i = lo; i < hi; ++i) {
                if (this.isSelected(i) != positive) continue;
                array[offset++] = array[i];
            }
            return offset;
        }
    }

    static abstract class DPap
    extends AbstractParallelAnyArray {
        double[] array;

        DPap(ForkJoinExecutor ex, int origin, int fence, double[] array) {
            super(ex, origin, fence);
            this.array = array;
        }

        @Override
        final double[] dgetArray() {
            return this.array;
        }

        @Override
        Object oget(int i) {
            return this.dget(i);
        }

        @Override
        long lget(int i) {
            return (long)this.dget(i);
        }

        @Override
        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            double[] array = this.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }

        @Override
        final int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            double[] array = this.array;
            for (int i = lo; i < hi; ++i) {
                if (this.isSelected(i) != positive) continue;
                array[offset++] = array[i];
            }
            return offset;
        }
    }

    static abstract class OPap<T>
    extends AbstractParallelAnyArray {
        T[] array;

        OPap(ForkJoinExecutor ex, int origin, int fence, T[] array) {
            super(ex, origin, fence);
            this.array = array;
        }

        @Override
        final Object[] ogetArray() {
            return this.array;
        }

        @Override
        double dget(int i) {
            return ((Number)this.oget(i)).doubleValue();
        }

        @Override
        long lget(int i) {
            return ((Number)this.oget(i)).longValue();
        }

        @Override
        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            T[] array = this.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }

        @Override
        final int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            T[] array = this.array;
            for (int i = lo; i < hi; ++i) {
                if (this.isSelected(i) != positive) continue;
                array[offset++] = array[i];
            }
            return offset;
        }
    }
}

