/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public class Phaser {
    private volatile long state;
    private static final int ushortBits = 16;
    private static final int ushortMask = 65535;
    private static final int phaseMask = Integer.MAX_VALUE;
    private final Phaser parent;
    private final Phaser root;
    private final AtomicReference<QNode> evenQ = new AtomicReference();
    private final AtomicReference<QNode> oddQ = new AtomicReference();
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 32;
    static final long spinForTimeoutThreshold = 1000L;
    static final Unsafe _unsafe;
    static final long stateOffset;

    private static int unarrivedOf(long s) {
        return (int)(s & 0xFFFFL);
    }

    private static int partiesOf(long s) {
        return (int)(s & 0xFFFFFFFFFFFF0000L) >>> 16;
    }

    private static int phaseOf(long s) {
        return (int)(s >>> 32);
    }

    private static int arrivedOf(long s) {
        return Phaser.partiesOf(s) - Phaser.unarrivedOf(s);
    }

    private static long stateFor(int phase, int parties, int unarrived) {
        return (long)phase << 32 | (long)(parties << 16 | unarrived);
    }

    private static long trippedStateFor(int phase, int parties) {
        return (long)phase << 32 | (long)(parties << 16 | parties);
    }

    private static IllegalStateException badBounds(int parties, int unarrived) {
        return new IllegalStateException("Attempt to set " + unarrived + " unarrived of " + parties + " parties");
    }

    private AtomicReference<QNode> queueFor(int phase) {
        return (phase & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private long getReconciledState() {
        return this.parent == null ? this.state : this.reconcileState();
    }

    private long reconcileState() {
        Phaser p = this.parent;
        long s = this.state;
        if (p != null) {
            while (Phaser.unarrivedOf(s) == 0 && Phaser.phaseOf(s) != Phaser.phaseOf(this.root.state)) {
                long next;
                long parentState = p.getReconciledState();
                int parentPhase = Phaser.phaseOf(parentState);
                s = this.state;
                int phase = Phaser.phaseOf(s);
                if (phase == parentPhase || !this.casState(s, next = Phaser.trippedStateFor(parentPhase, Phaser.partiesOf(s)))) continue;
                this.releaseWaiters(phase);
                s = next;
            }
        }
        return s;
    }

    public Phaser() {
        this(null);
    }

    public Phaser(int parties) {
        this(null, parties);
    }

    public Phaser(Phaser parent) {
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            this.root = parent.root;
            phase = parent.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(phase, 0);
    }

    public Phaser(Phaser parent, int parties) {
        if (parties < 0 || parties > 65535) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            this.root = parent.root;
            phase = parent.register();
        } else {
            this.root = this;
        }
        this.state = Phaser.trippedStateFor(phase, parties);
    }

    public int register() {
        return this.doRegister(1);
    }

    public int bulkRegister(int parties) {
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        if (parties == 0) {
            return this.getPhase();
        }
        return this.doRegister(parties);
    }

    private int doRegister(int registrations) {
        int unarrived;
        int parties;
        long s;
        int phase;
        do {
            s = this.getReconciledState();
            phase = Phaser.phaseOf(s);
            unarrived = Phaser.unarrivedOf(s) + registrations;
            parties = Phaser.partiesOf(s) + registrations;
            if (phase < 0) break;
            if (parties <= 65535 && unarrived <= 65535) continue;
            throw Phaser.badBounds(parties, unarrived);
        } while (phase != Phaser.phaseOf(this.root.state) || !this.casState(s, Phaser.stateFor(phase, parties, unarrived)));
        return phase;
    }

    public int arrive() {
        int phase;
        block5: {
            int unarrived;
            int parties;
            while (true) {
                long s = this.state;
                phase = Phaser.phaseOf(s);
                parties = Phaser.partiesOf(s);
                unarrived = Phaser.unarrivedOf(s) - 1;
                if (unarrived > 0) {
                    if (!this.casState(s, s - 1L)) continue;
                    break block5;
                }
                if (unarrived == 0) {
                    Phaser par = this.parent;
                    if (par == null) {
                        if (!this.casState(s, Phaser.trippedStateFor(this.onAdvance(phase, parties) ? -1 : phase + 1 & Integer.MAX_VALUE, parties))) continue;
                        this.releaseWaiters(phase);
                    } else {
                        if (!this.casState(s, s - 1L)) continue;
                        par.arrive();
                        this.reconcileState();
                    }
                    break block5;
                }
                if (phase < 0) break block5;
                if (phase == Phaser.phaseOf(this.root.state)) break;
                this.reconcileState();
            }
            throw Phaser.badBounds(parties, unarrived);
        }
        return phase;
    }

    public int arriveAndDeregister() {
        int phase;
        block7: {
            int unarrived;
            int parties;
            Phaser par = this.parent;
            while (true) {
                long s = this.state;
                phase = Phaser.phaseOf(s);
                parties = Phaser.partiesOf(s) - 1;
                unarrived = Phaser.unarrivedOf(s) - 1;
                if (parties < 0) break;
                if (unarrived > 0 || unarrived == 0 && par != null) {
                    if (!this.casState(s, Phaser.stateFor(phase, parties, unarrived))) continue;
                    if (unarrived == 0) {
                        par.arriveAndDeregister();
                        this.reconcileState();
                    }
                } else if (unarrived == 0) {
                    if (!this.casState(s, Phaser.trippedStateFor(this.onAdvance(phase, parties) ? -1 : phase + 1 & Integer.MAX_VALUE, parties))) continue;
                    this.releaseWaiters(phase);
                } else if (phase >= 0) {
                    if (par == null || phase == Phaser.phaseOf(this.root.state)) break;
                    this.reconcileState();
                    continue;
                }
                break block7;
                break;
            }
            throw Phaser.badBounds(parties, unarrived);
        }
        return phase;
    }

    public int arriveAndAwaitAdvance() {
        return this.awaitAdvance(this.arrive());
    }

    public int awaitAdvance(int phase) {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) == 0) {
            this.parent.awaitAdvance(phase);
        }
        return this.untimedWait(phase);
    }

    public int awaitAdvanceInterruptibly(int phase) throws InterruptedException {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) != 0) {
            this.parent.awaitAdvanceInterruptibly(phase);
        }
        return this.interruptibleWait(phase);
    }

    public int awaitAdvanceInterruptibly(int phase, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (phase < 0) {
            return phase;
        }
        long s = this.getReconciledState();
        int p = Phaser.phaseOf(s);
        if (p != phase) {
            return p;
        }
        if (Phaser.unarrivedOf(s) == 0) {
            this.parent.awaitAdvanceInterruptibly(phase, timeout, unit);
        }
        return this.timedWait(phase, unit.toNanos(timeout));
    }

    public void forceTermination() {
        int unarrived;
        int parties;
        long s;
        int phase;
        do {
            s = this.getReconciledState();
            phase = Phaser.phaseOf(s);
            parties = Phaser.partiesOf(s);
            unarrived = Phaser.unarrivedOf(s);
        } while (phase >= 0 && !this.casState(s, Phaser.stateFor(-1, parties, unarrived)));
        this.releaseWaiters(0);
        this.releaseWaiters(1);
        if (this.parent != null) {
            this.parent.forceTermination();
        }
    }

    public final int getPhase() {
        return Phaser.phaseOf(this.getReconciledState());
    }

    public final boolean hasPhase(int phase) {
        return Phaser.phaseOf(this.getReconciledState()) == phase;
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.state);
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.state);
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.getPhase() < 0;
    }

    protected boolean onAdvance(int phase, int registeredParties) {
        return registeredParties <= 0;
    }

    public String toString() {
        long s = this.getReconciledState();
        return super.toString() + "[phase = " + Phaser.phaseOf(s) + " parties = " + Phaser.partiesOf(s) + " arrived = " + Phaser.arrivedOf(s) + "]";
    }

    private void releaseWaiters(int phase) {
        QNode q;
        AtomicReference<QNode> head = this.queueFor(phase);
        while ((q = head.get()) != null) {
            if (!head.compareAndSet(q, q.next)) continue;
            q.signal();
        }
    }

    private int untimedWait(int phase) {
        int p;
        int spins = maxUntimedSpins;
        QNode node = null;
        boolean interrupted = false;
        boolean queued = false;
        while ((p = this.getPhase()) == phase) {
            interrupted = Thread.interrupted();
            if (node != null) {
                if (!queued) {
                    AtomicReference<QNode> head = this.queueFor(phase);
                    node.next = head.get();
                    queued = head.compareAndSet(node.next, node);
                    continue;
                }
                if (node.thread == null) continue;
                LockSupport.park(this);
                continue;
            }
            if (spins <= 0) {
                node = new QNode();
                continue;
            }
            --spins;
        }
        if (node != null) {
            node.thread = null;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.releaseWaiters(phase);
        return p;
    }

    private int interruptibleWait(int phase) throws InterruptedException {
        int p;
        int spins = maxUntimedSpins;
        QNode node = null;
        boolean queued = false;
        boolean interrupted = false;
        while ((p = this.getPhase()) == phase && !(interrupted = Thread.interrupted())) {
            if (node != null) {
                if (!queued) {
                    AtomicReference<QNode> head = this.queueFor(phase);
                    node.next = head.get();
                    queued = head.compareAndSet(node.next, node);
                    continue;
                }
                if (node.thread == null) continue;
                LockSupport.park(this);
                continue;
            }
            if (spins <= 0) {
                node = new QNode();
                continue;
            }
            --spins;
        }
        if (node != null) {
            node.thread = null;
        }
        if (interrupted) {
            throw new InterruptedException();
        }
        this.releaseWaiters(phase);
        return p;
    }

    private int timedWait(int phase, long nanos) throws InterruptedException, TimeoutException {
        int p = this.getPhase();
        if (p == phase) {
            long now;
            long lastTime = System.nanoTime();
            int spins = maxTimedSpins;
            QNode node = null;
            boolean queued = false;
            boolean interrupted = false;
            while ((p = this.getPhase()) == phase && !(interrupted = Thread.interrupted()) && (nanos -= (now = System.nanoTime()) - lastTime) > 0L) {
                lastTime = now;
                if (node != null) {
                    if (!queued) {
                        AtomicReference<QNode> head = this.queueFor(phase);
                        node.next = head.get();
                        queued = head.compareAndSet(node.next, node);
                        continue;
                    }
                    if (node.thread == null || nanos <= 1000L) continue;
                    LockSupport.parkNanos(this, nanos);
                    continue;
                }
                if (spins <= 0) {
                    node = new QNode();
                    continue;
                }
                --spins;
            }
            if (node != null) {
                node.thread = null;
            }
            if (interrupted) {
                throw new InterruptedException();
            }
            if (p == phase && (p = this.getPhase()) == phase) {
                throw new TimeoutException();
            }
        }
        this.releaseWaiters(phase);
        return p;
    }

    final boolean casState(long cmp, long val) {
        return _unsafe.compareAndSwapLong(this, stateOffset, cmp, val);
    }

    static {
        try {
            if (Phaser.class.getClassLoader() != null) {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                _unsafe = (Unsafe)f.get(null);
            } else {
                _unsafe = Unsafe.getUnsafe();
            }
            stateOffset = _unsafe.objectFieldOffset(Phaser.class.getDeclaredField("state"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    static final class QNode {
        QNode next;
        volatile Thread thread = Thread.currentThread();

        QNode() {
        }

        void signal() {
            Thread t = this.thread;
            if (t != null) {
                this.thread = null;
                LockSupport.unpark(t);
            }
        }
    }
}

