package memoire;

public class EntreeTableSymbole {
	public String id; // identifiant
	public String obj; // var, cst, meth 
	public String sorte; // entier, booleen ou void
	public String profil; // profil des parametre si fonction
	public String portee; // portee du symbole dans le programme
	
	public EntreeTableSymbole(String id, String obj, String sorte, String portee){
		this.id=id;
		this.obj=obj;
		this.sorte=sorte;
		this.profil=null;
		this.portee=portee;
	}
	
	public EntreeTableSymbole(String id, String obj, String sorte, String profil, String portee){
		this.id=id;
		this.obj=obj;
		this.sorte=sorte;
		this.profil=profil;
		this.portee=portee;
	}
	
	public boolean isId(String id){
		return this.id.equals(id);
	}
	
	public boolean isObj(String obj){
		return this.obj.equals(obj);
	}
	
	public boolean isSorte(String sorte){
		return this.sorte.equals(sorte);
	}
	
	public boolean isProfil(String profil){
		return this.profil.equals(profil);
	}
	
	public boolean isPortee(String portee){
		return this.portee.equals(portee);
	}
	
	public boolean equals(EntreeTableSymbole ets){
		return(ets.isId(this.id) && ets.isObj(this.obj) && ets.isSorte(this.sorte) && ets.isProfil(this.profil) && ets.isPortee(this.portee));
	}
	
	public String toString(){
		return "<" + this.id + "," + this.obj + "," + this.sorte + "," + this.profil + "," + this.portee + ">";
	}
	
}
