#!/bin/bash

echo -e "algo;nbproc;granularite;maxiter;exec_time" > result.csv

maxiter=50000

mandelbrot_seq $maxiter >> result.csv

# Test en fonction du nombre de processus esclave
for ((nbproc=4;nbproc<=16;nbproc+=2))
do
	# Fait plusieurs fois le test de suite
	for ((granularite=5000;granularite<=100000;granularite+=5000))
	do
		echo "doing proc=$nbproc granu=$granularite maxiter=$maxiter"
		mpirun -c $nbproc mandelbrot_cs $granularite $maxiter >> result.csv
		mpirun -c $nbproc mandelbrot_cd $granularite $maxiter >> result.csv
	done
done
